local A1, A2 = 727595, 798405  -- 5^17=D20*A1+A2
local D20, D40 = 1048576, 1099511627776  -- 2^20, 2^40
local X1, X2 = 0, 1
function rand()
    local U = X2*A2
    local V = (X1*A2 + X2*A1) % D20
    V = (V*D20 + U) % D40
    X1 = math.floor(V/D20)
    X2 = V - X1*D20
    return V/D40
end
function RandBetween(a, b)
	local r = rand()
	local d = b-a
	local e = d*r
	return a + e
end
function GetMiddle(a,b)
	return math.floor((a+b)/2)
end
function GetAngleFacingClaw(self)
	local claw = GetClaw()
	if claw.State == 26 then
		return math.deg(math.atan2(claw.Y-self.Y+32,claw.X-self.X))
	else
		return math.deg(math.atan2(claw.Y-self.Y,claw.X-self.X))
	end
end

function GetAngleFacingClaw2(x, y)
	local claw = GetClaw()
	if claw.State == 26 then
		return math.deg(math.atan2(claw.Y-y+32,claw.X-x))
	else
		return math.deg(math.atan2(claw.Y-y,claw.X-x))
	end
end

function GetAngleFacingSelf(self, x, y)
	return math.deg(math.atan2(self.hotY-y,self.hotX-x))
end

-- States:
-- 0 - initialization
-- 1 - between attacks
-- 2 - getting hit
-- 3 - ranged attack
-- 4 - special attack
-- 10 - after fight

function LookAtClaw(self)
	if self.X > GetClaw().X then
		self.DrawFlags.Mirror = false
	else
		self.DrawFlags.Mirror = true
	end
end

--[[function getMoveCoords(input)
	local coords = {x=0, y=0}
	if input == "LB" then
		coords.x = RandBetween(11520, 11648)
		coords.y = RandBetween(2048, 2175)
	elseif input == "LT" then
		coords.x = RandBetween(11520, 11648)
		coords.y = RandBetween(1790, 1920)
	elseif input == "RB" then
		coords.x = RandBetween(12095, 12222)
		coords.y = RandBetween(2048, 2175)
	elseif input == "RT" then
		coords.x = RandBetween(12095, 12222)
		coords.y = RandBetween(1790, 1920)
	elseif input == "MB" then
		coords.x = RandBetween(11904, 12028)
		coords.y = RandBetween(2048, 2175)
	elseif input == "MT" then
		coords.x = RandBetween(11712, 12032)
		coords.y = RandBetween(1600, 1664)
	end
	return coords
end--]]

function IsInTheZone(self, input)
	if input == "LB" then
		if self.hotX >= 11540 and self.hotX <= 11648 and
			self.hotY >= 2048 and self.hotY <= 2175 then
			return -99
		else
			return math.atan2(2100-self.hotY,11600-self.hotX)
		end
	elseif input == "LT" then
		if self.hotX >= 11540 and self.hotX <= 11648 and
			self.hotY >= 1790 and self.hotY <= 1920 then
			return -99
		else
			return math.atan2(1850-self.hotY,11600-self.hotX)
		end
	elseif input == "RB" then
		if self.hotX >= 12179 and self.hotX <= 12286 and
			self.hotY >= 2048 and self.hotY <= 2175 then
			return -99
		else
			return math.atan2(2100-self.hotY,12214-self.hotX)
		end
	elseif input == "RT" then
		if self.hotX >= 12179 and self.hotX <= 12286 and
			self.hotY >= 1790 and self.hotY <= 1920 then
			return -99
		else
			return math.atan2(1850-self.hotY,12214-self.hotX)
		end
	elseif input == "MB" then
		if self.hotX >= 11904 and self.hotX <= 12028 and
			self.hotY >= 2048 and self.hotY <= 2175 then
			return -99
		else
			return math.atan2(2100-self.hotY,11950-self.hotX)
		end
	elseif input == "MT" then
		if self.hotX >= 11904 and self.hotX <= 12032 and
			self.hotY >= 1600 and self.hotY <= 1664 then
			return -99
		else
			return math.atan2(1630-self.hotY,11950-self.hotX)
		end
	elseif input == "MB2" then
		if self.hotX >= 11904 and self.hotX <= 12028 and
			self.hotY >= 2264 and self.hotY <= 2500 then
			return -99
		else
			return math.atan2(2268-self.hotY,11950-self.hotX)
		end
	elseif input == "NULL" then
		return -99
	end
	return coords
end

function getDistance(x1, x2, y1, y2)
	return math.sqrt((x1-x2)^2+(y1-y2)^2)
end

--[[function StartMovement(self, input, speed)
	local dest = getMoveCoords(input)
	self.MovXStart = self.X
	self.MovYStart = self.Y
	self.MovXFin = dest.x
	self.MovYFin = dest.y
	self.MovTStart = GetTime()
	self.MovAngle = math.atan2(self.MovYFin-self.MovYStart,self.MovXFin-self.MovXStart)
	self.Moving = speed
end--]]

function getFloatingYModifier(self)
	return math.sin(GetTime()/(350.0))*(31.0/10.0)
end
function main(self)
	if self.DrawFlags.Mirror then
		self.dir = 1
	else
		self.dir = -1
	end
	--TextOut(GetAngleFacingClaw(self))
	if self.State == 0 then
		self.X = 11976
		self.Y = 2154
		self.hotX = 11976
		self.hotY = 2154
		--self.Floor = 1
		
		self.Health = 100
		if self.MPcheckpointFlag ~= nil then
			self.Health = 55
		end
		self.Achievements = GetObject(4088)
		if self.Achievements.extra == true then
			self.Health = 200
		end
		self.Damage = 5
		--self.AttackTypeFlags = ObjectType.Player
		--self.DefaultAttackRect = {-16,-8,16,16}
		--self.AttackRect = self.DefaultAttackRect
		
		self.XMin = 13536
		self.XMax = 14050
		self.Floor2Y = 2834
		self.Floor1Y = 2464
		self.Floor0Y = 2080

		self.ObjectTypeFlags = 4
		self.WpierdolCounter = 0
		self.NormalReload = 1200
		self.SpecialReload = 2500
		
		self.TimeStoppedTill = 0
		self.TimeStoppedDuration = 0
		
		--self.I = 1
		--self:SetImage("LEVEL_ARETI")
		--self:SetAnimation("GAME_NULL")
		--self.Z = 4001
		
		self.TimeCounter = GetTime() + self.NormalReload
		
		self.HitTypeFlags = 50335794
		--self.HitTypeFlags = ObjectType.Player + ObjectType.PShot
		self.HitRect = {-14,-35,14,31}
		--self.AC1cd = 500
		--self.AC2cd = 3000
		--self.ACMcd = 3000
		--self.SC1cd = 100
		--self.SC1cd2 = 250
		--self.AC1 = GetTime() + 3000
		--self.AC2 = 0
		self.movementInput = {}
		if self.Achievements.HardMode == false and self.Achievements.extra == false then
			self.movementInput[1] = {}
			self.movementInput[1]["spell_name"] = "none"
			self.movementInput[1]["spell_card"] = "none"
			self.movementInput[1]["spell_length"] = 3000
			self.movementInput[1]["spell_totallength"] = 5000
			self.movementInput[1]["spell_type"] = "repeating"
			self.movementInput[1]["position"] = "MB"
			self.movementInput[1]["movement_pattern"] = "false"
			self.movementInput[1]["spell_hp_threshold"] = 85
			--self.movementInput[1]["positionX"] = 90
			self.movementInput[1]["bullets"] = {}
			--self.movementInput[1]["bullets"]["count"] = 2
			self.movementInput[1]["bullets"][1] = {}
			self.movementInput[1]["bullets"][1]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[1]["bullets"][1]["i"] = 1
			self.movementInput[1]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][1]["spread_angle"] = 30
			self.movementInput[1]["bullets"][1]["spread_translation"] = 0
			self.movementInput[1]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[1]["bullets"][1]["delay"] = -800
			self.movementInput[1]["bullets"][1]["speed"] = 0
			self.movementInput[1]["bullets"][2] = {}
			self.movementInput[1]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[1]["bullets"][2]["i"] = 1
			self.movementInput[1]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][2]["spread_angle"] = 30
			self.movementInput[1]["bullets"][2]["spread_translation"] = 15 -- arc difference from base direction
			self.movementInput[1]["bullets"][2]["internal_cooldown"] = 1000
			self.movementInput[1]["bullets"][2]["delay"] = -300 -- delay from spell start
			self.movementInput[1]["bullets"][2]["speed"] = 0
			
			self.movementInput[2] = {}
			self.movementInput[2]["spell_name"] = "Triple Blade"
			self.movementInput[2]["spell_card"] = "2"
			self.movementInput[2]["spell_length"] = 13000
			self.movementInput[2]["spell_totallength"] = 15000
			self.movementInput[2]["spell_type"] = "main"
			self.movementInput[2]["position"] = "RT"
			self.movementInput[2]["movement_pattern"] = "false"
			self.movementInput[2]["bullets"] = {}
			self.movementInput[2]["bullets"][1] = {}
			self.movementInput[2]["bullets"][1]["type"] = 2
			self.movementInput[2]["bullets"][1]["i"] = 1
			self.movementInput[2]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[2]["bullets"][1]["spread_angle"] = 30
			self.movementInput[2]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[2]["bullets"][1]["spread_translation"] = 0
			self.movementInput[2]["bullets"][1]["internal_cooldown"] = 300
			self.movementInput[2]["bullets"][1]["shotgun_frags"] = 1
			self.movementInput[2]["bullets"][1]["delay"] = 0
			self.movementInput[2]["bullets"][1]["speed"] = 3000
			self.movementInput[2]["bullets"][2] = {}
			self.movementInput[2]["bullets"][2]["type"] = 1
			self.movementInput[2]["bullets"][2]["i"] = 1
			self.movementInput[2]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][2]["spread_angle"] = 60
			self.movementInput[2]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][2]["spread_translation"] = 0
			self.movementInput[2]["bullets"][2]["internal_cooldown"] = 1200
			self.movementInput[2]["bullets"][2]["delay"] = 0
			self.movementInput[2]["bullets"][2]["speed"] = 0
			self.movementInput[2]["bullets"][3] = {}
			self.movementInput[2]["bullets"][3]["type"] = 1
			self.movementInput[2]["bullets"][3]["i"] = 1
			self.movementInput[2]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][3]["spread_angle"] = 60
			self.movementInput[2]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][3]["spread_translation"] = -20
			self.movementInput[2]["bullets"][3]["internal_cooldown"] = 1800
			self.movementInput[2]["bullets"][3]["delay"] = 0
			self.movementInput[2]["bullets"][3]["speed"] = 0
			self.movementInput[2]["bullets"][4] = {}
			self.movementInput[2]["bullets"][4]["type"] = 1
			self.movementInput[2]["bullets"][4]["i"] = 1
			self.movementInput[2]["bullets"][4]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][4]["spread_angle"] = 60
			self.movementInput[2]["bullets"][4]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][4]["spread_translation"] = -40
			self.movementInput[2]["bullets"][4]["internal_cooldown"] = 1800
			self.movementInput[2]["bullets"][4]["delay"] = 800
			self.movementInput[2]["bullets"][4]["speed"] = 0
			self.movementInput[2]["bullets"][5] = {}
			self.movementInput[2]["bullets"][5]["type"] = 1
			self.movementInput[2]["bullets"][5]["i"] = 2
			self.movementInput[2]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[2]["bullets"][5]["spread_angle"] = 10
			self.movementInput[2]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[2]["bullets"][5]["spread_translation"] = 0
			self.movementInput[2]["bullets"][5]["internal_cooldown"] = 2500
			self.movementInput[2]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[2]["bullets"][5]["delay"] = -1500
			self.movementInput[2]["bullets"][5]["speed"] = 4500
			
			self.movementInput[3] = {}
			self.movementInput[3]["spell_name"] = "none"
			self.movementInput[3]["spell_card"] = "none"
			self.movementInput[3]["spell_length"] = 6000
			self.movementInput[3]["spell_totallength"] = 10500
			self.movementInput[3]["spell_type"] = "repeating"
			self.movementInput[3]["position"] = "RT"
			self.movementInput[3]["movement_pattern"] = "false"
			self.movementInput[3]["spell_hp_threshold"] = 70
			self.movementInput[3]["bullets"] = {}
			self.movementInput[3]["bullets"][1] = {}
			self.movementInput[3]["bullets"][1]["type"] = 1
			self.movementInput[3]["bullets"][1]["i"] = 1
			self.movementInput[3]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][1]["spread_angle"] = 60
			self.movementInput[3]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][1]["spread_translation"] = 0
			self.movementInput[3]["bullets"][1]["internal_cooldown"] = 1500
			self.movementInput[3]["bullets"][1]["delay"] = 0
			self.movementInput[3]["bullets"][1]["speed"] = 0
			self.movementInput[3]["bullets"][2] = {}
			self.movementInput[3]["bullets"][2]["type"] = 1
			self.movementInput[3]["bullets"][2]["i"] = 1
			self.movementInput[3]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][2]["spread_angle"] = 60
			self.movementInput[3]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][2]["spread_translation"] = -20
			self.movementInput[3]["bullets"][2]["internal_cooldown"] = 1500
			self.movementInput[3]["bullets"][2]["delay"] = 500
			self.movementInput[3]["bullets"][2]["speed"] = 0
			self.movementInput[3]["bullets"][3] = {}
			self.movementInput[3]["bullets"][3]["type"] = 1
			self.movementInput[3]["bullets"][3]["i"] = 1
			self.movementInput[3]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][3]["spread_angle"] = 60
			self.movementInput[3]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][3]["spread_translation"] = -40
			self.movementInput[3]["bullets"][3]["internal_cooldown"] = 1500
			self.movementInput[3]["bullets"][3]["delay"] = 1000
			self.movementInput[3]["bullets"][3]["speed"] = 0
			self.movementInput[3]["bullets"][4] = {}
			self.movementInput[3]["bullets"][4]["type"] = 1
			self.movementInput[3]["bullets"][4]["i"] = 2
			self.movementInput[3]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][4]["spread_angle"] = 5
			self.movementInput[3]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][4]["spread_translation"] = 0
			self.movementInput[3]["bullets"][4]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][4]["shotgun_frags"] = 1
			self.movementInput[3]["bullets"][4]["delay"] = -1500
			self.movementInput[3]["bullets"][4]["speed"] = 3600
			self.movementInput[3]["bullets"][5] = {}
			self.movementInput[3]["bullets"][5]["type"] = 1
			self.movementInput[3]["bullets"][5]["i"] = 2
			self.movementInput[3]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][5]["spread_angle"] = 15
			self.movementInput[3]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][5]["spread_translation"] = 0
			self.movementInput[3]["bullets"][5]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[3]["bullets"][5]["delay"] = -1300
			self.movementInput[3]["bullets"][5]["speed"] = 3800
			self.movementInput[3]["bullets"][6] = {}
			self.movementInput[3]["bullets"][6]["type"] = 1
			self.movementInput[3]["bullets"][6]["i"] = 2
			self.movementInput[3]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][6]["spread_angle"] = 20
			self.movementInput[3]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][6]["spread_translation"] = 0
			self.movementInput[3]["bullets"][6]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][6]["shotgun_frags"] = 3
			self.movementInput[3]["bullets"][6]["delay"] = -1100
			self.movementInput[3]["bullets"][6]["speed"] = 4000
			
			self.movementInput[4] = {}
			self.movementInput[4]["spell_name"] = "Disasterous Rain"
			self.movementInput[4]["spell_card"] = "2"
			self.movementInput[4]["spell_length"] = 25000
			self.movementInput[4]["spell_totallength"] = 32000
			self.movementInput[4]["spell_type"] = "main"
			self.movementInput[4]["position"] = "MT"
			self.movementInput[4]["movement_pattern"] = "false"
			self.movementInput[4]["bullets"] = {}
			self.movementInput[4]["bullets"][1] = {}
			self.movementInput[4]["bullets"][1]["type"] = 1
			self.movementInput[4]["bullets"][1]["i"] = 1
			self.movementInput[4]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][1]["spread_angle"] = 0
			self.movementInput[4]["bullets"][1]["spread_distance"] = 128
			self.movementInput[4]["bullets"][1]["spread_interval"] = 72
			self.movementInput[4]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[4]["bullets"][1]["behaviour"] = 0 --bullet behaviour
			self.movementInput[4]["bullets"][1]["internal_cooldown"] = 2500
			self.movementInput[4]["bullets"][1]["delay"] = -2500
			self.movementInput[4]["bullets"][1]["speed"] = 6000
			self.movementInput[4]["bullets"][2] = {}
			self.movementInput[4]["bullets"][2]["type"] = 4 -- meteor
			self.movementInput[4]["bullets"][2]["i"] = 2
			self.movementInput[4]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][2]["spread_angle"] = 0
			self.movementInput[4]["bullets"][2]["spread_distance"] = 468
			self.movementInput[4]["bullets"][2]["spread_interval"] = 192
			self.movementInput[4]["bullets"][2]["spread_dstart"] = 128
			self.movementInput[4]["bullets"][2]["behaviour"] = 0
			self.movementInput[4]["bullets"][2]["internal_cooldown"] = 2500
			self.movementInput[4]["bullets"][2]["delay"] = -2000
			self.movementInput[4]["bullets"][2]["speed"] = 3000
			self.movementInput[4]["bullets"][3] = {}
			self.movementInput[4]["bullets"][3]["type"] = 1
			self.movementInput[4]["bullets"][3]["i"] = 1
			self.movementInput[4]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][3]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][3]["spread_angle"] = 0
			self.movementInput[4]["bullets"][3]["spread_distance"] = 128
			self.movementInput[4]["bullets"][3]["spread_interval"] = 56
			self.movementInput[4]["bullets"][3]["spread_dstart"] = 68
			self.movementInput[4]["bullets"][3]["behaviour"] = 0
			self.movementInput[4]["bullets"][3]["internal_cooldown"] = 2500
			self.movementInput[4]["bullets"][3]["delay"] = -1000
			self.movementInput[4]["bullets"][3]["speed"] = 6000
			
			self.movementInput[5] = {}
			self.movementInput[5]["spell_name"] = "none"
			self.movementInput[5]["spell_card"] = "none"
			self.movementInput[5]["spell_length"] = 4000
			self.movementInput[5]["spell_totallength"] = 8000
			self.movementInput[5]["spell_type"] = "repeating"
			self.movementInput[5]["position"] = "LT"
			self.movementInput[5]["movement_pattern"] = "false"
			self.movementInput[5]["spell_hp_threshold"] = 55
			self.movementInput[5]["bullets"] = {}
			self.movementInput[5]["bullets"][1] = {}
			self.movementInput[5]["bullets"][1]["type"] = 1
			self.movementInput[5]["bullets"][1]["i"] = 1
			self.movementInput[5]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][1]["spread_origin"] = "left"
			self.movementInput[5]["bullets"][1]["spread_angle"] = 0
			self.movementInput[5]["bullets"][1]["spread_distance"] = 64
			self.movementInput[5]["bullets"][1]["spread_interval"] = 0
			self.movementInput[5]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][1]["behaviour"] = 0
			self.movementInput[5]["bullets"][1]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][1]["delay"] = -1500
			self.movementInput[5]["bullets"][1]["speed"] = 6000
			self.movementInput[5]["bullets"][2] = {}
			self.movementInput[5]["bullets"][2]["type"] = 1
			self.movementInput[5]["bullets"][2]["i"] = 1
			self.movementInput[5]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][2]["spread_origin"] = "right"
			self.movementInput[5]["bullets"][2]["spread_angle"] = 0
			self.movementInput[5]["bullets"][2]["spread_distance"] = 64
			self.movementInput[5]["bullets"][2]["spread_interval"] = 0
			self.movementInput[5]["bullets"][2]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][2]["behaviour"] = 0
			self.movementInput[5]["bullets"][2]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][2]["delay"] = -1500
			self.movementInput[5]["bullets"][2]["speed"] = 6000
			self.movementInput[5]["bullets"][3] = {}
			self.movementInput[5]["bullets"][3]["type"] = 1
			self.movementInput[5]["bullets"][3]["i"] = 1
			self.movementInput[5]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][3]["spread_origin"] = "top"
			self.movementInput[5]["bullets"][3]["spread_angle"] = 0
			self.movementInput[5]["bullets"][3]["spread_distance"] = 64
			self.movementInput[5]["bullets"][3]["spread_interval"] = 0
			self.movementInput[5]["bullets"][3]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][3]["behaviour"] = 0
			self.movementInput[5]["bullets"][3]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][3]["delay"] = -3900
			self.movementInput[5]["bullets"][3]["speed"] = 6000
			self.movementInput[5]["bullets"][4] = {}
			self.movementInput[5]["bullets"][4]["type"] = 1
			self.movementInput[5]["bullets"][4]["i"] = 1
			self.movementInput[5]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][4]["spread_origin"] = "bottom"
			self.movementInput[5]["bullets"][4]["spread_angle"] = 0
			self.movementInput[5]["bullets"][4]["spread_distance"] = 64
			self.movementInput[5]["bullets"][4]["spread_interval"] = 0
			self.movementInput[5]["bullets"][4]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][4]["behaviour"] = 0
			self.movementInput[5]["bullets"][4]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][4]["delay"] = -1500
			self.movementInput[5]["bullets"][4]["speed"] = 6000
			self.movementInput[5]["bullets"][5] = {}
			self.movementInput[5]["bullets"][5]["type"] = 1
			self.movementInput[5]["bullets"][5]["i"] = 2
			self.movementInput[5]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][5]["spread_angle"] = 30
			self.movementInput[5]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][5]["spread_translation"] = 0
			self.movementInput[5]["bullets"][5]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][5]["delay"] = -6000
			self.movementInput[5]["bullets"][5]["speed"] = 5000
			self.movementInput[5]["bullets"][6] = {}
			self.movementInput[5]["bullets"][6]["type"] = 1
			self.movementInput[5]["bullets"][6]["i"] = 2
			self.movementInput[5]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][6]["spread_angle"] = 30
			self.movementInput[5]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][6]["spread_translation"] = 0
			self.movementInput[5]["bullets"][6]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][6]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][6]["delay"] = -5500
			self.movementInput[5]["bullets"][6]["speed"] = 5000
			self.movementInput[5]["bullets"][7] = {}
			self.movementInput[5]["bullets"][7]["type"] = 1
			self.movementInput[5]["bullets"][7]["i"] = 2
			self.movementInput[5]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][7]["spread_angle"] = 30
			self.movementInput[5]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][7]["spread_translation"] = 0
			self.movementInput[5]["bullets"][7]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][7]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][7]["delay"] = -5000
			self.movementInput[5]["bullets"][7]["speed"] = 5000
			
			
			self.movementInput[6] = {}
			self.movementInput[6]["spell_name"] = "Tetragonal Thrust"
			self.movementInput[6]["spell_card"] = "2"
			self.movementInput[6]["spell_length"] = 20200
			self.movementInput[6]["spell_totallength"] = 22200
			self.movementInput[6]["spell_type"] = "main"
			self.movementInput[6]["position"] = "LB"
			self.movementInput[6]["movement_pattern"] = "false"
			self.movementInput[6]["bullets"] = {}
			self.movementInput[6]["bullets"][1] = {}
			self.movementInput[6]["bullets"][1]["type"] = 5
			self.movementInput[6]["bullets"][1]["i"] = 1
			self.movementInput[6]["bullets"][1]["spread_type"] = "clockwise"
			self.movementInput[6]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[6]["bullets"][1]["spread_dstart"] = 90
			self.movementInput[6]["bullets"][1]["internal_cooldown"] = 1200
			self.movementInput[6]["bullets"][1]["delay"] = -1200
			self.movementInput[6]["bullets"][1]["speed"] = 1000
			
			self.movementInput[7] = {}
			self.movementInput[7]["spell_name"] = "none"
			self.movementInput[7]["spell_card"] = "none"
			self.movementInput[7]["spell_length"] = 10000
			self.movementInput[7]["spell_totallength"] = 13000
			self.movementInput[7]["spell_type"] = "repeating"
			self.movementInput[7]["position"] = "LT"
			self.movementInput[7]["movement_pattern"] = "false"
			self.movementInput[7]["spell_hp_threshold"] = 40
			self.movementInput[7]["bullets"] = {}
			self.movementInput[7]["bullets"][1] = {}
			self.movementInput[7]["bullets"][1]["type"] = 5
			self.movementInput[7]["bullets"][1]["i"] = 1
			self.movementInput[7]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[7]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[7]["bullets"][1]["spread_angle"] = 0
			self.movementInput[7]["bullets"][1]["spread_distance"] = 320
			self.movementInput[7]["bullets"][1]["spread_interval"] = 64
			self.movementInput[7]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[7]["bullets"][1]["behaviour"] = 0
			self.movementInput[7]["bullets"][1]["internal_cooldown"] = 3000
			self.movementInput[7]["bullets"][1]["delay"] = -3000
			self.movementInput[7]["bullets"][1]["speed"] = 1000
			self.movementInput[7]["bullets"][2] = {}
			self.movementInput[7]["bullets"][2]["type"] = 1
			self.movementInput[7]["bullets"][2]["i"] = 2
			self.movementInput[7]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[7]["bullets"][2]["spread_angle"] = 20
			self.movementInput[7]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[7]["bullets"][2]["spread_translation"] = 0
			self.movementInput[7]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[7]["bullets"][2]["shotgun_frags"] = 5
			self.movementInput[7]["bullets"][2]["delay"] = -2000
			self.movementInput[7]["bullets"][2]["speed"] = 4000
			self.movementInput[7]["bullets"][3] = {}
			self.movementInput[7]["bullets"][3]["type"] = 1
			self.movementInput[7]["bullets"][3]["i"] = 1
			self.movementInput[7]["bullets"][3]["spread_type"] = "mpcheckpoint"
			self.movementInput[7]["bullets"][3]["internal_cooldown"] = 1000
			self.movementInput[7]["bullets"][3]["delay"] = -900
			self.movementInput[7]["bullets"][3]["speed"] = 0
			
			self.movementInput[8] = {}
			self.movementInput[8]["spell_name"] = "The World"
			self.movementInput[8]["spell_card"] = "2"
			self.movementInput[8]["spell_length"] = 42000
			self.movementInput[8]["spell_totallength"] = 46000
			self.movementInput[8]["spell_type"] = "main"
			self.movementInput[8]["position"] = "MT"
			self.movementInput[8]["movement_pattern"] = "false"
			self.movementInput[8]["bullets"] = {}
			self.movementInput[8]["bullets"][1] = {}
			self.movementInput[8]["bullets"][1]["spread_type"] = "timestop"
			self.movementInput[8]["bullets"][1]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][1]["length"] = 2000
			self.movementInput[8]["bullets"][1]["delay"] = -2000
			
			self.movementInput[8]["bullets"][2] = {}
			self.movementInput[8]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][2]["i"] = 1
			self.movementInput[8]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][2]["spread_angle"] = 12
			self.movementInput[8]["bullets"][2]["spread_translation"] = 0 -- arc difference from base direction
			self.movementInput[8]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][2]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][2]["speed"] = 4000
			
			self.movementInput[8]["bullets"][3] = {}
			self.movementInput[8]["bullets"][3]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][3]["i"] = 2
			self.movementInput[8]["bullets"][3]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][3]["spread_angle"] = 12
			self.movementInput[8]["bullets"][3]["spread_translation"] = 3 -- arc difference from base direction
			self.movementInput[8]["bullets"][3]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][3]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][3]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][3]["speed"] = 5500
			
			self.movementInput[8]["bullets"][4] = {}
			self.movementInput[8]["bullets"][4]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][4]["i"] = 3
			self.movementInput[8]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][4]["spread_angle"] = 12
			self.movementInput[8]["bullets"][4]["spread_translation"] = 6 -- arc difference from base direction
			self.movementInput[8]["bullets"][4]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][4]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][4]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][4]["speed"] = 7000
			
			self.movementInput[8]["bullets"][9] = {}
			self.movementInput[8]["bullets"][9]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][9]["i"] = 4
			self.movementInput[8]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][9]["spread_angle"] = 12
			self.movementInput[8]["bullets"][9]["spread_translation"] = 9 -- arc difference from base direction
			self.movementInput[8]["bullets"][9]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][9]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][9]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][9]["speed"] = 9000
			
			self.movementInput[8]["bullets"][5] = {}
			self.movementInput[8]["bullets"][5]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][5]["i"] = 1
			self.movementInput[8]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][5]["spread_angle"] = 7
			self.movementInput[8]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][5]["tsdistance"] = 96
			self.movementInput[8]["bullets"][5]["spread_translation"] = -1
			self.movementInput[8]["bullets"][5]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][5]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][5]["delay"] = -1900
			self.movementInput[8]["bullets"][5]["speed"] = 2000
			
			self.movementInput[8]["bullets"][6] = {}
			self.movementInput[8]["bullets"][6]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][6]["i"] = 1
			self.movementInput[8]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][6]["spread_angle"] = 7
			self.movementInput[8]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][6]["tsdistance"] = 160
			self.movementInput[8]["bullets"][6]["spread_translation"] = 2
			self.movementInput[8]["bullets"][6]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][6]["shotgun_frags"] = 6
			self.movementInput[8]["bullets"][6]["delay"] = -1800
			self.movementInput[8]["bullets"][6]["speed"] = 2000
			
			self.movementInput[8]["bullets"][7] = {}
			self.movementInput[8]["bullets"][7]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][7]["i"] = 1
			self.movementInput[8]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][7]["spread_angle"] = 3
			self.movementInput[8]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][7]["tsdistance"] = 224
			self.movementInput[8]["bullets"][7]["spread_translation"] = -12
			self.movementInput[8]["bullets"][7]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][7]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][7]["delay"] = -1750
			self.movementInput[8]["bullets"][7]["speed"] = 2000
			
			self.movementInput[8]["bullets"][8] = {}
			self.movementInput[8]["bullets"][8]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][8]["i"] = 1
			self.movementInput[8]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][8]["spread_angle"] = 3
			self.movementInput[8]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][8]["tsdistance"] = 288
			self.movementInput[8]["bullets"][8]["spread_translation"] = 12
			self.movementInput[8]["bullets"][8]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][8]["delay"] = -1700
			self.movementInput[8]["bullets"][8]["speed"] = 2000
			
			self.movementInput[8]["bullets"][10] = {}
			self.movementInput[8]["bullets"][10]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][10]["i"] = 1
			self.movementInput[8]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][10]["spread_angle"] = 3
			self.movementInput[8]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][10]["tsdistance"] = 332
			self.movementInput[8]["bullets"][10]["spread_translation"] = -12
			self.movementInput[8]["bullets"][10]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][10]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][10]["delay"] = -1650
			self.movementInput[8]["bullets"][10]["speed"] = 2000
			
			self.movementInput[8]["bullets"][11] = {}
			self.movementInput[8]["bullets"][11]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][11]["i"] = 1
			self.movementInput[8]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][11]["spread_angle"] = 6
			self.movementInput[8]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][11]["tsdistance"] = 416
			self.movementInput[8]["bullets"][11]["spread_translation"] = 0
			self.movementInput[8]["bullets"][11]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][11]["shotgun_frags"] = 10
			self.movementInput[8]["bullets"][11]["delay"] = -1600
			self.movementInput[8]["bullets"][11]["speed"] = 2000
			
			local dd = 0
			self.movementInput[9] = {}
			self.movementInput[9]["spell_name"] = "none"
			self.movementInput[9]["spell_card"] = "none"
			self.movementInput[9]["spell_length"] = 4000
			self.movementInput[9]["spell_totallength"] = 11500
			self.movementInput[9]["spell_type"] = "repeating"
			self.movementInput[9]["position"] = "RB"
			self.movementInput[9]["movement_pattern"] = "false"
			self.movementInput[9]["spell_hp_threshold"] = 25
			self.movementInput[9]["bullets"] = {}
			self.movementInput[9]["bullets"][1] = {}
			self.movementInput[9]["bullets"][1]["type"] = 1
			self.movementInput[9]["bullets"][1]["i"] = 1
			self.movementInput[9]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][1]["spread_angle"] = 5 + dd
			self.movementInput[9]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][1]["spread_translation"] = 0
			self.movementInput[9]["bullets"][1]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][1]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][1]["delay"] = -4000
			self.movementInput[9]["bullets"][1]["speed"] = 4000
			self.movementInput[9]["bullets"][2] = {}
			self.movementInput[9]["bullets"][2]["type"] = 1
			self.movementInput[9]["bullets"][2]["i"] = 1
			self.movementInput[9]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][2]["spread_angle"] = 6 + dd
			self.movementInput[9]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][2]["spread_translation"] = 0
			self.movementInput[9]["bullets"][2]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][2]["delay"] = -3800
			self.movementInput[9]["bullets"][2]["speed"] = 4000
			self.movementInput[9]["bullets"][3] = {}
			self.movementInput[9]["bullets"][3]["type"] = 1
			self.movementInput[9]["bullets"][3]["i"] = 1
			self.movementInput[9]["bullets"][3]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][3]["spread_angle"] = 8 + dd
			self.movementInput[9]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][3]["spread_translation"] = 0
			self.movementInput[9]["bullets"][3]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][3]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][3]["delay"] = -3600
			self.movementInput[9]["bullets"][3]["speed"] = 4000
			self.movementInput[9]["bullets"][4] = {}
			self.movementInput[9]["bullets"][4]["type"] = 1
			self.movementInput[9]["bullets"][4]["i"] = 1
			self.movementInput[9]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][4]["spread_angle"] = 10 + dd
			self.movementInput[9]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][4]["spread_translation"] = 0
			self.movementInput[9]["bullets"][4]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][4]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][4]["delay"] = -3400
			self.movementInput[9]["bullets"][4]["speed"] = 4000
			self.movementInput[9]["bullets"][5] = {}
			self.movementInput[9]["bullets"][5]["type"] = 1
			self.movementInput[9]["bullets"][5]["i"] = 1
			self.movementInput[9]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][5]["spread_angle"] = 13 + dd
			self.movementInput[9]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][5]["spread_translation"] = 0
			self.movementInput[9]["bullets"][5]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][5]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][5]["delay"] = -3200
			self.movementInput[9]["bullets"][5]["speed"] = 4000
			self.movementInput[9]["bullets"][6] = {}
			self.movementInput[9]["bullets"][6]["type"] = 1
			self.movementInput[9]["bullets"][6]["i"] = 1
			self.movementInput[9]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][6]["spread_angle"] = 16 + dd
			self.movementInput[9]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][6]["spread_translation"] = 0
			self.movementInput[9]["bullets"][6]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][6]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][6]["delay"] = -3000
			self.movementInput[9]["bullets"][6]["speed"] = 4000
			self.movementInput[9]["bullets"][7] = {}
			self.movementInput[9]["bullets"][7]["type"] = 1
			self.movementInput[9]["bullets"][7]["i"] = 1
			self.movementInput[9]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][7]["spread_angle"] = 18 + dd
			self.movementInput[9]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][7]["spread_translation"] = 0
			self.movementInput[9]["bullets"][7]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][7]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][7]["delay"] = -2800
			self.movementInput[9]["bullets"][7]["speed"] = 4000
			self.movementInput[9]["bullets"][8] = {}
			self.movementInput[9]["bullets"][8]["type"] = 1
			self.movementInput[9]["bullets"][8]["i"] = 1
			self.movementInput[9]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][8]["spread_angle"] = 20 + dd
			self.movementInput[9]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][8]["spread_translation"] = 0
			self.movementInput[9]["bullets"][8]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][8]["delay"] = -2600
			self.movementInput[9]["bullets"][8]["speed"] = 4000
			self.movementInput[9]["bullets"][9] = {}
			self.movementInput[9]["bullets"][9]["type"] = 1
			self.movementInput[9]["bullets"][9]["i"] = 1
			self.movementInput[9]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][9]["spread_angle"] = 21 + dd
			self.movementInput[9]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][9]["spread_translation"] = 0
			self.movementInput[9]["bullets"][9]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][9]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][9]["delay"] = -2400
			self.movementInput[9]["bullets"][9]["speed"] = 4000
			self.movementInput[9]["bullets"][10] = {}
			self.movementInput[9]["bullets"][10]["type"] = 1
			self.movementInput[9]["bullets"][10]["i"] = 1
			self.movementInput[9]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][10]["spread_angle"] = 22 + dd
			self.movementInput[9]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][10]["spread_translation"] = 0
			self.movementInput[9]["bullets"][10]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][10]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][10]["delay"] = -2200
			self.movementInput[9]["bullets"][10]["speed"] = 4000
			self.movementInput[9]["bullets"][11] = {}
			self.movementInput[9]["bullets"][11]["type"] = 1
			self.movementInput[9]["bullets"][11]["i"] = 1
			self.movementInput[9]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][11]["spread_angle"] = 22 + dd
			self.movementInput[9]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][11]["spread_translation"] = 0
			self.movementInput[9]["bullets"][11]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][11]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][11]["delay"] = -2000
			self.movementInput[9]["bullets"][11]["speed"] = 4000
			
			self.movementInput[9]["bullets"][12] = {}
			self.movementInput[9]["bullets"][12]["type"] = 1
			self.movementInput[9]["bullets"][12]["i"] = 1
			self.movementInput[9]["bullets"][12]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][12]["spread_angle"] = 21 + dd
			self.movementInput[9]["bullets"][12]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][12]["spread_translation"] = 0
			self.movementInput[9]["bullets"][12]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][12]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][12]["delay"] = -1800
			self.movementInput[9]["bullets"][12]["speed"] = 4000
			
			self.movementInput[9]["bullets"][13] = {}
			self.movementInput[9]["bullets"][13]["type"] = 1
			self.movementInput[9]["bullets"][13]["i"] = 1
			self.movementInput[9]["bullets"][13]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][13]["spread_angle"] = 20 + dd
			self.movementInput[9]["bullets"][13]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][13]["spread_translation"] = 0
			self.movementInput[9]["bullets"][13]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][13]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][13]["delay"] = -1600
			self.movementInput[9]["bullets"][13]["speed"] = 4000
			
			self.movementInput[9]["bullets"][14] = {}
			self.movementInput[9]["bullets"][14]["type"] = 1
			self.movementInput[9]["bullets"][14]["i"] = 1
			self.movementInput[9]["bullets"][14]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][14]["spread_angle"] = 18 + dd
			self.movementInput[9]["bullets"][14]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][14]["spread_translation"] = 0
			self.movementInput[9]["bullets"][14]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][14]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][14]["delay"] = -1400
			self.movementInput[9]["bullets"][14]["speed"] = 4000
			
			self.movementInput[9]["bullets"][15] = {}
			self.movementInput[9]["bullets"][15]["type"] = 1
			self.movementInput[9]["bullets"][15]["i"] = 1
			self.movementInput[9]["bullets"][15]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][15]["spread_angle"] = 16 + dd
			self.movementInput[9]["bullets"][15]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][15]["spread_translation"] = 0
			self.movementInput[9]["bullets"][15]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][15]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][15]["delay"] = -1200
			self.movementInput[9]["bullets"][15]["speed"] = 4000
			
			self.movementInput[9]["bullets"][16] = {}
			self.movementInput[9]["bullets"][16]["type"] = 1
			self.movementInput[9]["bullets"][16]["i"] = 1
			self.movementInput[9]["bullets"][16]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][16]["spread_angle"] = 13 + dd
			self.movementInput[9]["bullets"][16]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][16]["spread_translation"] = 0
			self.movementInput[9]["bullets"][16]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][16]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][16]["delay"] = -1000
			self.movementInput[9]["bullets"][16]["speed"] = 4000
			
			self.movementInput[9]["bullets"][17] = {}
			self.movementInput[9]["bullets"][17]["type"] = 1
			self.movementInput[9]["bullets"][17]["i"] = 1
			self.movementInput[9]["bullets"][17]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][17]["spread_angle"] = 10 + dd
			self.movementInput[9]["bullets"][17]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][17]["spread_translation"] = 0
			self.movementInput[9]["bullets"][17]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][17]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][17]["delay"] = -800
			self.movementInput[9]["bullets"][17]["speed"] = 4000
			
			self.movementInput[9]["bullets"][18] = {}
			self.movementInput[9]["bullets"][18]["type"] = 1
			self.movementInput[9]["bullets"][18]["i"] = 1
			self.movementInput[9]["bullets"][18]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][18]["spread_angle"] = 8 + dd
			self.movementInput[9]["bullets"][18]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][18]["spread_translation"] = 0
			self.movementInput[9]["bullets"][18]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][18]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][18]["delay"] = -600
			self.movementInput[9]["bullets"][18]["speed"] = 4000
			
			self.movementInput[9]["bullets"][19] = {}
			self.movementInput[9]["bullets"][19]["type"] = 1
			self.movementInput[9]["bullets"][19]["i"] = 1
			self.movementInput[9]["bullets"][19]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][19]["spread_angle"] = 7 + dd
			self.movementInput[9]["bullets"][19]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][19]["spread_translation"] = 0
			self.movementInput[9]["bullets"][19]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][19]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][19]["delay"] = -400
			self.movementInput[9]["bullets"][19]["speed"] = 4000
			
			self.movementInput[9]["bullets"][20] = {}
			self.movementInput[9]["bullets"][20]["type"] = 1
			self.movementInput[9]["bullets"][20]["i"] = 1
			self.movementInput[9]["bullets"][20]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][20]["spread_angle"] = 6 + dd
			self.movementInput[9]["bullets"][20]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][20]["spread_translation"] = 0
			self.movementInput[9]["bullets"][20]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][20]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][20]["delay"] = -200
			self.movementInput[9]["bullets"][20]["speed"] = 4000
			
			
			self.movementInput[10] = {}
			self.movementInput[10]["spell_name"] = "Eldritch Epiphany"
			self.movementInput[10]["spell_card"] = "2"
			self.movementInput[10]["spell_length"] = 42000
			self.movementInput[10]["spell_totallength"] = 48000
			self.movementInput[10]["spell_type"] = "main"
			self.movementInput[10]["position"] = "LB"
			self.movementInput[10]["movement_pattern"] = "false"
			self.movementInput[10]["bullets"] = {}
			self.movementInput[10]["bullets"][1] = {}
			self.movementInput[10]["bullets"][1]["type"] = 7
			self.movementInput[10]["bullets"][1]["i"] = 2
			self.movementInput[10]["bullets"][1]["spread_type"] = "orbit"
			self.movementInput[10]["bullets"][1]["spread_angle"] = 30
			self.movementInput[10]["bullets"][1]["spread_distance"] = 128
			self.movementInput[10]["bullets"][1]["internal_cooldown"] = 50000
			self.movementInput[10]["bullets"][1]["delay"] = -50000
			self.movementInput[10]["bullets"][1]["speed"] = 0
			
			self.movementInput[10]["bullets"][2] = {}
			self.movementInput[10]["bullets"][2]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][2]["i"] = 5
			self.movementInput[10]["bullets"][2]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][2]["spread_base"] = "boundaries"
			self.movementInput[10]["bullets"][2]["repeats"] = 1
			self.movementInput[10]["bullets"][2]["internal_cooldown"] = 600
			self.movementInput[10]["bullets"][2]["delay"] = 0
			self.movementInput[10]["bullets"][2]["speed"] = 0
			
			self.movementInput[10]["bullets"][4] = {}
			self.movementInput[10]["bullets"][4]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][4]["i"] = 5
			self.movementInput[10]["bullets"][4]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][4]["spread_base"] = "proximity"
			self.movementInput[10]["bullets"][4]["repeats"] = 1
			self.movementInput[10]["bullets"][4]["internal_cooldown"] = 500
			self.movementInput[10]["bullets"][4]["delay"] = 0
			self.movementInput[10]["bullets"][4]["speed"] = 0
			self.movementInput[10]["bullets"][5] = {}
			self.movementInput[10]["bullets"][5]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][5]["i"] = 5
			self.movementInput[10]["bullets"][5]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[10]["bullets"][5]["repeats"] = 1
			self.movementInput[10]["bullets"][5]["internal_cooldown"] = 2100
			self.movementInput[10]["bullets"][5]["delay"] = 50
			self.movementInput[10]["bullets"][5]["speed"] = 0
			
			self.movementInput[10]["bullets"][3] = {}
			self.movementInput[10]["bullets"][3]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][3]["i"] = 4
			self.movementInput[10]["bullets"][3]["spread_type"] = "pulsar"
			self.movementInput[10]["bullets"][3]["spread_angle"] = 180
			self.movementInput[10]["bullets"][3]["spread_interval"] = 11
			self.movementInput[10]["bullets"][3]["spread_dstart"] = 0
			self.movementInput[10]["bullets"][3]["spread_translation"] = 0
			self.movementInput[10]["bullets"][3]["internal_cooldown"] = 330
			self.movementInput[10]["bullets"][3]["delay"] = 2000
			self.movementInput[10]["bullets"][3]["speed"] = 3000
			
			self.movementInput[11] = {}
			self.movementInput[11]["spell_name"] = "WIN!!!"
			self.movementInput[11]["spell_card"] = "2"
			self.movementInput[11]["spell_length"] = 1000
			self.movementInput[11]["spell_totallength"] = 1000
			self.movementInput[11]["spell_type"] = "repeating"
			self.movementInput[11]["position"] = "LB"
			self.movementInput[11]["movement_pattern"] = "false"
			self.movementInput[11]["spell_hp_threshold"] = 10
			self.movementInput[11]["bullets"] = {}
			self.movementInput[11]["bullets"][1] = {}
			self.movementInput[11]["bullets"][1]["type"] = 1
			self.movementInput[11]["bullets"][1]["i"] = 1
			self.movementInput[11]["bullets"][1]["spread_type"] = "victory"
			self.movementInput[11]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[11]["bullets"][1]["delay"] = -1000
			self.movementInput[11]["bullets"][1]["speed"] = 0
		
		elseif self.Achievements.extra == false then
		
			self.movementInput[1] = {}
			self.movementInput[1]["spell_name"] = "none"
			self.movementInput[1]["spell_card"] = "none"
			self.movementInput[1]["spell_length"] = 3000
			self.movementInput[1]["spell_totallength"] = 5500
			self.movementInput[1]["spell_type"] = "repeating"
			self.movementInput[1]["position"] = "MB"
			self.movementInput[1]["movement_pattern"] = "false"
			self.movementInput[1]["spell_hp_threshold"] = 85
			self.movementInput[1]["bullets"] = {}
			self.movementInput[1]["bullets"][1] = {}
			self.movementInput[1]["bullets"][1]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[1]["bullets"][1]["i"] = 2
			self.movementInput[1]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][1]["spread_angle"] = 20
			self.movementInput[1]["bullets"][1]["spread_translation"] = 0
			self.movementInput[1]["bullets"][1]["internal_cooldown"] = 800
			self.movementInput[1]["bullets"][1]["delay"] = -600
			self.movementInput[1]["bullets"][1]["speed"] = 3500
			self.movementInput[1]["bullets"][2] = {}
			self.movementInput[1]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[1]["bullets"][2]["i"] = 1
			self.movementInput[1]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][2]["spread_angle"] = 20
			self.movementInput[1]["bullets"][2]["spread_translation"] = 10 -- arc difference from base direction
			self.movementInput[1]["bullets"][2]["internal_cooldown"] = 800
			self.movementInput[1]["bullets"][2]["delay"] = -200 -- delay from spell start
			self.movementInput[1]["bullets"][2]["speed"] = 0
			
			self.movementInput[2] = {}
			self.movementInput[2]["spell_name"] = "Endless Depth"
			self.movementInput[2]["spell_card"] = "2"
			self.movementInput[2]["spell_length"] = 25000
			self.movementInput[2]["spell_totallength"] = 28000
			self.movementInput[2]["spell_type"] = "main"
			self.movementInput[2]["position"] = "LB"
			self.movementInput[2]["movement_pattern"] = "false"
			self.movementInput[2]["bullets"] = {}
			
			self.movementInput[2]["bullets"][1] = {}
			self.movementInput[2]["bullets"][1]["type"] = 9
			self.movementInput[2]["bullets"][1]["i"] = 3
			self.movementInput[2]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[2]["bullets"][1]["spread_origin"] = "bottom"
			self.movementInput[2]["bullets"][1]["spread_angle"] = 0
			self.movementInput[2]["bullets"][1]["spread_distance"] = 64
			self.movementInput[2]["bullets"][1]["spread_interval"] = 32
			self.movementInput[2]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[2]["bullets"][1]["behaviour"] = 0
			self.movementInput[2]["bullets"][1]["internal_cooldown"] = 2000
			self.movementInput[2]["bullets"][1]["delay"] = -1600
			self.movementInput[2]["bullets"][1]["speed"] = 6000
			
			self.movementInput[3] = {}
			self.movementInput[3]["spell_name"] = "none"
			self.movementInput[3]["spell_card"] = "none"
			self.movementInput[3]["spell_length"] = 5000
			self.movementInput[3]["spell_totallength"] = 15000
			self.movementInput[3]["spell_type"] = "repeating"
			self.movementInput[3]["position"] = "MT"
			self.movementInput[3]["movement_pattern"] = "false"
			self.movementInput[3]["spell_hp_threshold"] = 70
			self.movementInput[3]["bullets"] = {}
			
			self.movementInput[3]["bullets"][1] = {}
			self.movementInput[3]["bullets"][1]["type"] = 1
			self.movementInput[3]["bullets"][1]["i"] = 1
			self.movementInput[3]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[3]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[3]["bullets"][1]["spread_angle"] = 0
			self.movementInput[3]["bullets"][1]["spread_distance"] = 965
			self.movementInput[3]["bullets"][1]["spread_interval"] = -32
			self.movementInput[3]["bullets"][1]["spread_dstart"] = 961
			self.movementInput[3]["bullets"][1]["behaviour"] = 1 --bullet behaviour
			self.movementInput[3]["bullets"][1]["internal_cooldown"] = 167
			self.movementInput[3]["bullets"][1]["delay"] = -166
			self.movementInput[3]["bullets"][1]["speed"] = 4500
			
			self.movementInput[3]["bullets"][2] = {}
			self.movementInput[3]["bullets"][2]["type"] = 1
			self.movementInput[3]["bullets"][2]["i"] = 1
			self.movementInput[3]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[3]["bullets"][2]["spread_origin"] = "bottom"
			self.movementInput[3]["bullets"][2]["spread_angle"] = 0
			self.movementInput[3]["bullets"][2]["spread_distance"] = 970
			self.movementInput[3]["bullets"][2]["spread_interval"] = 32
			self.movementInput[3]["bullets"][2]["spread_dstart"] = 1
			self.movementInput[3]["bullets"][2]["behaviour"] = 1 --bullet behaviour
			self.movementInput[3]["bullets"][2]["internal_cooldown"] = 167
			self.movementInput[3]["bullets"][2]["delay"] = -166
			self.movementInput[3]["bullets"][2]["speed"] = 4500
			
			self.movementInput[3]["bullets"][3] = {}
			self.movementInput[3]["bullets"][3]["type"] = 1
			self.movementInput[3]["bullets"][3]["i"] = 1
			self.movementInput[3]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[3]["bullets"][3]["spread_origin"] = "left"
			self.movementInput[3]["bullets"][3]["spread_angle"] = 0
			self.movementInput[3]["bullets"][3]["spread_distance"] = 1280
			self.movementInput[3]["bullets"][3]["spread_interval"] = -40
			self.movementInput[3]["bullets"][3]["spread_dstart"] = 1279
			self.movementInput[3]["bullets"][3]["behaviour"] = 1 --bullet behaviour
			self.movementInput[3]["bullets"][3]["internal_cooldown"] = 157
			self.movementInput[3]["bullets"][3]["delay"] = -157
			self.movementInput[3]["bullets"][3]["speed"] = 4500
			
			self.movementInput[3]["bullets"][4] = {}
			self.movementInput[3]["bullets"][4]["type"] = 1
			self.movementInput[3]["bullets"][4]["i"] = 1
			self.movementInput[3]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[3]["bullets"][4]["spread_origin"] = "right"
			self.movementInput[3]["bullets"][4]["spread_angle"] = 0
			self.movementInput[3]["bullets"][4]["spread_distance"] = 1280
			self.movementInput[3]["bullets"][4]["spread_interval"] = 40
			self.movementInput[3]["bullets"][4]["spread_dstart"] = 5
			self.movementInput[3]["bullets"][4]["behaviour"] = 1 --bullet behaviour
			self.movementInput[3]["bullets"][4]["internal_cooldown"] = 157
			self.movementInput[3]["bullets"][4]["delay"] = -157
			self.movementInput[3]["bullets"][4]["speed"] = 4500
			
			self.movementInput[4] = {}
			self.movementInput[4]["spell_name"] = "Boundary of Sea and Land"
			self.movementInput[4]["spell_card"] = "2"
			self.movementInput[4]["spell_length"] = 40000
			self.movementInput[4]["spell_totallength"] = 45000
			self.movementInput[4]["spell_type"] = "main"
			self.movementInput[4]["position"] = "LT"
			self.movementInput[4]["movement_pattern"] = "false"
			self.movementInput[4]["bullets"] = {}
			self.movementInput[4]["bullets"][1] = {}
			self.movementInput[4]["bullets"][1]["type"] = 1
			self.movementInput[4]["bullets"][1]["i"] = 1
			self.movementInput[4]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][1]["spread_angle"] = 0
			self.movementInput[4]["bullets"][1]["spread_distance"] = 48
			self.movementInput[4]["bullets"][1]["spread_interval"] = 24
			self.movementInput[4]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[4]["bullets"][1]["behaviour"] = 2 --bullet behaviour
			self.movementInput[4]["bullets"][1]["internal_cooldown"] = 450
			self.movementInput[4]["bullets"][1]["delay"] = -450
			self.movementInput[4]["bullets"][1]["speed"] = 2700
			
			self.movementInput[5] = {}
			self.movementInput[5]["spell_name"] = "none"
			self.movementInput[5]["spell_card"] = "none"
			self.movementInput[5]["spell_length"] = 180
			self.movementInput[5]["spell_totallength"] = 5000
			self.movementInput[5]["spell_type"] = "repeating"
			self.movementInput[5]["position"] = "RT"
			self.movementInput[5]["movement_pattern"] = "false"
			self.movementInput[5]["spell_hp_threshold"] = 55
			self.movementInput[5]["bullets"] = {}
			self.movementInput[5]["bullets"][1] = {}
			self.movementInput[5]["bullets"][1]["type"] = 10
			self.movementInput[5]["bullets"][1]["i"] = 1
			self.movementInput[5]["bullets"][1]["spread_type"] = "clockwise"
			self.movementInput[5]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[5]["bullets"][1]["spread_dstart"] = 90
			self.movementInput[5]["bullets"][1]["internal_cooldown"] = 100
			self.movementInput[5]["bullets"][1]["delay"] = -180
			self.movementInput[5]["bullets"][1]["speed"] = 1000
			
			self.movementInput[6] = {}
			self.movementInput[6]["spell_name"] = "Spitfire"
			self.movementInput[6]["spell_card"] = "2"
			self.movementInput[6]["spell_length"] = 40000
			self.movementInput[6]["spell_totallength"] = 42000
			self.movementInput[6]["spell_type"] = "main"
			self.movementInput[6]["position"] = "MT"
			self.movementInput[6]["movement_pattern"] = "false"
			self.movementInput[6]["bullets"] = {}
			self.movementInput[6]["bullets"][1] = {}
			self.movementInput[6]["bullets"][1]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[6]["bullets"][1]["i"] = 1
			self.movementInput[6]["bullets"][1]["spread_type"] = "fall"
			self.movementInput[6]["bullets"][1]["spread_base"] = "boundaries"
			self.movementInput[6]["bullets"][1]["repeats"] = 2
			self.movementInput[6]["bullets"][1]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][1]["delay"] = -6500
			self.movementInput[6]["bullets"][1]["speed"] = 0
			self.movementInput[6]["bullets"][2] = {}
			self.movementInput[6]["bullets"][2]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[6]["bullets"][2]["i"] = 1
			self.movementInput[6]["bullets"][2]["spread_type"] = "fall"
			self.movementInput[6]["bullets"][2]["spread_base"] = "boundaries"
			self.movementInput[6]["bullets"][2]["repeats"] = 3
			self.movementInput[6]["bullets"][2]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][2]["delay"] = -6400
			self.movementInput[6]["bullets"][2]["speed"] = 0
			self.movementInput[6]["bullets"][3] = {}
			self.movementInput[6]["bullets"][3]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[6]["bullets"][3]["i"] = 1
			self.movementInput[6]["bullets"][3]["spread_type"] = "fall"
			self.movementInput[6]["bullets"][3]["spread_base"] = "boundaries"
			self.movementInput[6]["bullets"][3]["repeats"] = 4
			self.movementInput[6]["bullets"][3]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][3]["delay"] = -6300
			self.movementInput[6]["bullets"][3]["speed"] = 0
			
			self.movementInput[6]["bullets"][4] = {}
			self.movementInput[6]["bullets"][4]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[6]["bullets"][4]["i"] = 1
			self.movementInput[6]["bullets"][4]["spread_type"] = "fall"
			self.movementInput[6]["bullets"][4]["spread_base"] = "boundaries"
			self.movementInput[6]["bullets"][4]["repeats"] = 5
			self.movementInput[6]["bullets"][4]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][4]["delay"] = -6200
			self.movementInput[6]["bullets"][4]["speed"] = 0
			
			self.movementInput[6]["bullets"][5] = {}
			self.movementInput[6]["bullets"][5]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[6]["bullets"][5]["i"] = 1
			self.movementInput[6]["bullets"][5]["spread_type"] = "fall"
			self.movementInput[6]["bullets"][5]["spread_base"] = "boundaries"
			self.movementInput[6]["bullets"][5]["repeats"] = 6
			self.movementInput[6]["bullets"][5]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][5]["delay"] = -6100
			self.movementInput[6]["bullets"][5]["speed"] = 0
			
			self.movementInput[6]["bullets"][6] = {}
			self.movementInput[6]["bullets"][6]["type"] = 1
			self.movementInput[6]["bullets"][6]["i"] = 2
			self.movementInput[6]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][6]["spread_angle"] = 6
			self.movementInput[6]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][6]["spread_translation"] = 0
			self.movementInput[6]["bullets"][6]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][6]["shotgun_frags"] = 1
			self.movementInput[6]["bullets"][6]["delay"] = -2500
			self.movementInput[6]["bullets"][6]["speed"] = 1800
			self.movementInput[6]["bullets"][7] = {}
			self.movementInput[6]["bullets"][7]["type"] = 1
			self.movementInput[6]["bullets"][7]["i"] = 2
			self.movementInput[6]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][7]["spread_angle"] = 6
			self.movementInput[6]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][7]["spread_translation"] = 0
			self.movementInput[6]["bullets"][7]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][7]["shotgun_frags"] = 1
			self.movementInput[6]["bullets"][7]["delay"] = -2500
			self.movementInput[6]["bullets"][7]["speed"] = 2000
			self.movementInput[6]["bullets"][8] = {}
			self.movementInput[6]["bullets"][8]["type"] = 1
			self.movementInput[6]["bullets"][8]["i"] = 2
			self.movementInput[6]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][8]["spread_angle"] = 4
			self.movementInput[6]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][8]["spread_translation"] = 2
			self.movementInput[6]["bullets"][8]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[6]["bullets"][8]["delay"] = -2500
			self.movementInput[6]["bullets"][8]["speed"] = 2400
			self.movementInput[6]["bullets"][9] = {}
			self.movementInput[6]["bullets"][9]["type"] = 1
			self.movementInput[6]["bullets"][9]["i"] = 2
			self.movementInput[6]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][9]["spread_angle"] = 4
			self.movementInput[6]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][9]["spread_translation"] = 2
			self.movementInput[6]["bullets"][9]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][9]["shotgun_frags"] = 12
			self.movementInput[6]["bullets"][9]["delay"] = -2500
			self.movementInput[6]["bullets"][9]["speed"] = 2600
			self.movementInput[6]["bullets"][10] = {}
			self.movementInput[6]["bullets"][10]["type"] = 1
			self.movementInput[6]["bullets"][10]["i"] = 2
			self.movementInput[6]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][10]["spread_angle"] = 4
			self.movementInput[6]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][10]["spread_translation"] = 2
			self.movementInput[6]["bullets"][10]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][10]["shotgun_frags"] = 12
			self.movementInput[6]["bullets"][10]["delay"] = -2500
			self.movementInput[6]["bullets"][10]["speed"] = 2800
			self.movementInput[6]["bullets"][11] = {}
			self.movementInput[6]["bullets"][11]["type"] = 1
			self.movementInput[6]["bullets"][11]["i"] = 2
			self.movementInput[6]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][11]["spread_angle"] = 4
			self.movementInput[6]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][11]["spread_translation"] = 2
			self.movementInput[6]["bullets"][11]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][11]["shotgun_frags"] = 12
			self.movementInput[6]["bullets"][11]["delay"] = -2500
			self.movementInput[6]["bullets"][11]["speed"] = 3000
			self.movementInput[6]["bullets"][12] = {}
			self.movementInput[6]["bullets"][12]["type"] = 1
			self.movementInput[6]["bullets"][12]["i"] = 2
			self.movementInput[6]["bullets"][12]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][12]["spread_angle"] = 4
			self.movementInput[6]["bullets"][12]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][12]["spread_translation"] = 0
			self.movementInput[6]["bullets"][12]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][12]["shotgun_frags"] = 2
			self.movementInput[6]["bullets"][12]["delay"] = -2500
			self.movementInput[6]["bullets"][12]["speed"] = 3500
			self.movementInput[6]["bullets"][13] = {}
			self.movementInput[6]["bullets"][13]["type"] = 1
			self.movementInput[6]["bullets"][13]["i"] = 2
			self.movementInput[6]["bullets"][13]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][13]["spread_angle"] = 6
			self.movementInput[6]["bullets"][13]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][13]["spread_translation"] = 0
			self.movementInput[6]["bullets"][13]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][13]["shotgun_frags"] = 2
			self.movementInput[6]["bullets"][13]["delay"] = -2500
			self.movementInput[6]["bullets"][13]["speed"] = 3700
			self.movementInput[6]["bullets"][14] = {}
			self.movementInput[6]["bullets"][14]["type"] = 1
			self.movementInput[6]["bullets"][14]["i"] = 2
			self.movementInput[6]["bullets"][14]["spread_type"] = "shotgun"
			self.movementInput[6]["bullets"][14]["spread_angle"] = 4
			self.movementInput[6]["bullets"][14]["spread_base"] = "claw"
			self.movementInput[6]["bullets"][14]["spread_translation"] = 0
			self.movementInput[6]["bullets"][14]["internal_cooldown"] = 8000
			self.movementInput[6]["bullets"][14]["shotgun_frags"] = 3
			self.movementInput[6]["bullets"][14]["delay"] = -2500
			self.movementInput[6]["bullets"][14]["speed"] = 3900
			
			self.movementInput[7] = {}
			self.movementInput[7]["spell_name"] = "none"
			self.movementInput[7]["spell_card"] = "none"
			self.movementInput[7]["spell_length"] = 2000
			self.movementInput[7]["spell_totallength"] = 5000
			self.movementInput[7]["spell_type"] = "repeating"
			self.movementInput[7]["position"] = "LB"
			self.movementInput[7]["movement_pattern"] = "false"
			self.movementInput[7]["spell_hp_threshold"] = 40
			self.movementInput[7]["bullets"] = {}
			self.movementInput[7]["bullets"][1] = {}
			self.movementInput[7]["bullets"][1]["type"] = 11
			self.movementInput[7]["bullets"][1]["i"] = 3
			self.movementInput[7]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[7]["bullets"][1]["spread_angle"] = 0
			self.movementInput[7]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[7]["bullets"][1]["spread_translation"] = 0
			self.movementInput[7]["bullets"][1]["internal_cooldown"] = 200
			self.movementInput[7]["bullets"][1]["shotgun_frags"] = 1
			self.movementInput[7]["bullets"][1]["delay"] = 100
			self.movementInput[7]["bullets"][1]["speed"] = 2500
			self.movementInput[7]["bullets"][2] = {}
			self.movementInput[7]["bullets"][2]["type"] = 11
			self.movementInput[7]["bullets"][2]["i"] = 3
			self.movementInput[7]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[7]["bullets"][2]["spread_angle"] = 20
			self.movementInput[7]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[7]["bullets"][2]["spread_translation"] = 0
			self.movementInput[7]["bullets"][2]["internal_cooldown"] = 1000
			self.movementInput[7]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[7]["bullets"][2]["delay"] = -200
			self.movementInput[7]["bullets"][2]["speed"] = 2500
			
			self.movementInput[8] = {}
			self.movementInput[8]["spell_name"] = "Circle of Stars"
			self.movementInput[8]["spell_card"] = "2"
			self.movementInput[8]["spell_length"] = 42000
			self.movementInput[8]["spell_totallength"] = 44000
			self.movementInput[8]["spell_type"] = "main"
			self.movementInput[8]["position"] = "MT"
			self.movementInput[8]["movement_pattern"] = "false"
			self.movementInput[8]["bullets"] = {}
			self.movementInput[8]["bullets"][1] = {}
			self.movementInput[8]["bullets"][1]["type"] = 1
			self.movementInput[8]["bullets"][1]["i"] = 1
			self.movementInput[8]["bullets"][1]["spread_type"] = "hunterseeker"
			self.movementInput[8]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[8]["bullets"][1]["spread_angle"] = 0
			self.movementInput[8]["bullets"][1]["spread_distance"] = 320
			self.movementInput[8]["bullets"][1]["spread_interval"] = 64
			self.movementInput[8]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[8]["bullets"][1]["behaviour"] = 0
			self.movementInput[8]["bullets"][1]["duration"] = 42000
			self.movementInput[8]["bullets"][1]["internal_cooldown"] = 60000
			self.movementInput[8]["bullets"][1]["delay"] = -60000
			self.movementInput[8]["bullets"][1]["speed"] = 1000
			self.movementInput[8]["bullets"][2] = {}
			self.movementInput[8]["bullets"][2]["type"] = 2
			self.movementInput[8]["bullets"][2]["i"] = 1
			self.movementInput[8]["bullets"][2]["spread_type"] = "hunterseeker"
			self.movementInput[8]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[8]["bullets"][2]["spread_angle"] = 0
			self.movementInput[8]["bullets"][2]["spread_distance"] = 320
			self.movementInput[8]["bullets"][2]["spread_interval"] = 64
			self.movementInput[8]["bullets"][2]["spread_dstart"] = 0
			self.movementInput[8]["bullets"][2]["behaviour"] = 0
			self.movementInput[8]["bullets"][2]["duration"] = 21000
			self.movementInput[8]["bullets"][2]["internal_cooldown"] = 60000
			self.movementInput[8]["bullets"][2]["delay"] = -39000
			self.movementInput[8]["bullets"][2]["speed"] = 1000
			
			self.movementInput[9] = {}
			self.movementInput[9]["spell_name"] = "none"
			self.movementInput[9]["spell_card"] = "none"
			self.movementInput[9]["spell_length"] = 3000
			self.movementInput[9]["spell_totallength"] = 6500
			self.movementInput[9]["spell_type"] = "repeating"
			self.movementInput[9]["position"] = "RB"
			self.movementInput[9]["movement_pattern"] = "false"
			self.movementInput[9]["spell_hp_threshold"] = 25
			self.movementInput[9]["bullets"] = {}
			self.movementInput[9]["bullets"][1] = {}
			self.movementInput[9]["bullets"][1]["type"] = 12 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[9]["bullets"][1]["i"] = 2
			self.movementInput[9]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[9]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[9]["bullets"][1]["spread_angle"] = 90
			self.movementInput[9]["bullets"][1]["spread_translation"] = 45
			self.movementInput[9]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[9]["bullets"][1]["delay"] = -900
			self.movementInput[9]["bullets"][1]["speed"] = 4000
			
			self.movementInput[10] = {}
			self.movementInput[10]["spell_name"] = "Opening the Eye"
			self.movementInput[10]["spell_card"] = "2"
			self.movementInput[10]["spell_length"] = 53000
			self.movementInput[10]["spell_totallength"] = 57000
			self.movementInput[10]["spell_type"] = "main"
			self.movementInput[10]["position"] = "LB"
			self.movementInput[10]["movement_pattern"] = "false"
			self.movementInput[10]["bullets"] = {}
			self.movementInput[10]["bullets"][1] = {}
			self.movementInput[10]["bullets"][1]["type"] = 2
			self.movementInput[10]["bullets"][1]["i"] = 1
			self.movementInput[10]["bullets"][1]["spread_type"] = "hunterseeker"
			self.movementInput[10]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[10]["bullets"][1]["spread_angle"] = 0
			self.movementInput[10]["bullets"][1]["spread_distance"] = 320
			self.movementInput[10]["bullets"][1]["spread_interval"] = 64
			self.movementInput[10]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[10]["bullets"][1]["behaviour"] = 1
			self.movementInput[10]["bullets"][1]["duration"] = 52900
			self.movementInput[10]["bullets"][1]["internal_cooldown"] = 60000
			self.movementInput[10]["bullets"][1]["delay"] = -60000
			self.movementInput[10]["bullets"][1]["speed"] = 1000
			
			self.movementInput[10]["bullets"][2] = {}
			self.movementInput[10]["bullets"][2]["type"] = 13
			self.movementInput[10]["bullets"][2]["i"] = 3
			self.movementInput[10]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[10]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[10]["bullets"][2]["spread_angle"] = 0
			self.movementInput[10]["bullets"][2]["spread_distance"] = 965
			self.movementInput[10]["bullets"][2]["spread_interval"] = -52
			self.movementInput[10]["bullets"][2]["spread_dstart"] = 961
			self.movementInput[10]["bullets"][2]["behaviour"] = 0 --bullet behaviour
			self.movementInput[10]["bullets"][2]["internal_cooldown"] = 120
			self.movementInput[10]["bullets"][2]["delay"] = -166
			self.movementInput[10]["bullets"][2]["speed"] = 3000
			
			self.movementInput[10]["bullets"][3] = {}
			self.movementInput[10]["bullets"][3]["type"] = 13
			self.movementInput[10]["bullets"][3]["i"] = 3
			self.movementInput[10]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[10]["bullets"][3]["spread_origin"] = "bottom"
			self.movementInput[10]["bullets"][3]["spread_angle"] = 0
			self.movementInput[10]["bullets"][3]["spread_distance"] = 970
			self.movementInput[10]["bullets"][3]["spread_interval"] = 52
			self.movementInput[10]["bullets"][3]["spread_dstart"] = 1
			self.movementInput[10]["bullets"][3]["behaviour"] = 0 --bullet behaviour
			self.movementInput[10]["bullets"][3]["internal_cooldown"] = 120
			self.movementInput[10]["bullets"][3]["delay"] = -166
			self.movementInput[10]["bullets"][3]["speed"] = 3000
			
			self.movementInput[10]["bullets"][4] = {}
			self.movementInput[10]["bullets"][4]["type"] = 13
			self.movementInput[10]["bullets"][4]["i"] = 3
			self.movementInput[10]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[10]["bullets"][4]["spread_origin"] = "left"
			self.movementInput[10]["bullets"][4]["spread_angle"] = 0
			self.movementInput[10]["bullets"][4]["spread_distance"] = 1280
			self.movementInput[10]["bullets"][4]["spread_interval"] = -52
			self.movementInput[10]["bullets"][4]["spread_dstart"] = 1279
			self.movementInput[10]["bullets"][4]["behaviour"] = 0 --bullet behaviour
			self.movementInput[10]["bullets"][4]["internal_cooldown"] = 110
			self.movementInput[10]["bullets"][4]["delay"] = -157
			self.movementInput[10]["bullets"][4]["speed"] = 3000
			
			self.movementInput[10]["bullets"][5] = {}
			self.movementInput[10]["bullets"][5]["type"] = 13
			self.movementInput[10]["bullets"][5]["i"] = 3
			self.movementInput[10]["bullets"][5]["spread_type"] = "rain"
			self.movementInput[10]["bullets"][5]["spread_origin"] = "right"
			self.movementInput[10]["bullets"][5]["spread_angle"] = 0
			self.movementInput[10]["bullets"][5]["spread_distance"] = 1280
			self.movementInput[10]["bullets"][5]["spread_interval"] = 52
			self.movementInput[10]["bullets"][5]["spread_dstart"] = 5
			self.movementInput[10]["bullets"][5]["behaviour"] = 0 --bullet behaviour
			self.movementInput[10]["bullets"][5]["internal_cooldown"] = 110
			self.movementInput[10]["bullets"][5]["delay"] = -157
			self.movementInput[10]["bullets"][5]["speed"] = 3000
			
			self.movementInput[11] = {}
			self.movementInput[11]["spell_name"] = "WIN!!!"
			self.movementInput[11]["spell_card"] = "2"
			self.movementInput[11]["spell_length"] = 1000
			self.movementInput[11]["spell_totallength"] = 1000
			self.movementInput[11]["spell_type"] = "repeating"
			self.movementInput[11]["position"] = "LB"
			self.movementInput[11]["movement_pattern"] = "false"
			self.movementInput[11]["spell_hp_threshold"] = 10
			self.movementInput[11]["bullets"] = {}
			self.movementInput[11]["bullets"][1] = {}
			self.movementInput[11]["bullets"][1]["type"] = 1
			self.movementInput[11]["bullets"][1]["i"] = 1
			self.movementInput[11]["bullets"][1]["spread_type"] = "victory"
			self.movementInput[11]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[11]["bullets"][1]["delay"] = -900
			self.movementInput[11]["bullets"][1]["speed"] = 0
		else
			self.movementInput[1] = {}
			self.movementInput[1]["spell_name"] = "none"
			self.movementInput[1]["spell_card"] = "none"
			self.movementInput[1]["spell_length"] = 3000
			self.movementInput[1]["spell_totallength"] = 5000
			self.movementInput[1]["spell_type"] = "repeating"
			self.movementInput[1]["position"] = "MB"
			self.movementInput[1]["movement_pattern"] = "false"
			self.movementInput[1]["spell_hp_threshold"] = 185
			--self.movementInput[1]["positionX"] = 90
			self.movementInput[1]["bullets"] = {}
			--self.movementInput[1]["bullets"]["count"] = 2
			self.movementInput[1]["bullets"][1] = {}
			self.movementInput[1]["bullets"][1]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[1]["bullets"][1]["i"] = 1
			self.movementInput[1]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][1]["spread_angle"] = 30
			self.movementInput[1]["bullets"][1]["spread_translation"] = 0
			self.movementInput[1]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[1]["bullets"][1]["delay"] = -800
			self.movementInput[1]["bullets"][1]["speed"] = 0
			self.movementInput[1]["bullets"][2] = {}
			self.movementInput[1]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[1]["bullets"][2]["i"] = 1
			self.movementInput[1]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[1]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[1]["bullets"][2]["spread_angle"] = 30
			self.movementInput[1]["bullets"][2]["spread_translation"] = 15 -- arc difference from base direction
			self.movementInput[1]["bullets"][2]["internal_cooldown"] = 1000
			self.movementInput[1]["bullets"][2]["delay"] = -300 -- delay from spell start
			self.movementInput[1]["bullets"][2]["speed"] = 0
			
			self.movementInput[2] = {}
			self.movementInput[2]["spell_name"] = "Triple Blade"
			self.movementInput[2]["spell_card"] = "2"
			self.movementInput[2]["spell_length"] = 15000
			self.movementInput[2]["spell_totallength"] = 17000
			self.movementInput[2]["spell_type"] = "main"
			self.movementInput[2]["position"] = "RT"
			self.movementInput[2]["movement_pattern"] = "false"
			self.movementInput[2]["bullets"] = {}
			self.movementInput[2]["bullets"][1] = {}
			self.movementInput[2]["bullets"][1]["type"] = 2
			self.movementInput[2]["bullets"][1]["i"] = 1
			self.movementInput[2]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[2]["bullets"][1]["spread_angle"] = 30
			self.movementInput[2]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[2]["bullets"][1]["spread_translation"] = 0
			self.movementInput[2]["bullets"][1]["internal_cooldown"] = 250
			self.movementInput[2]["bullets"][1]["shotgun_frags"] = 1
			self.movementInput[2]["bullets"][1]["delay"] = 0
			self.movementInput[2]["bullets"][1]["speed"] = 3000
			self.movementInput[2]["bullets"][2] = {}
			self.movementInput[2]["bullets"][2]["type"] = 1
			self.movementInput[2]["bullets"][2]["i"] = 1
			self.movementInput[2]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][2]["spread_angle"] = 60
			self.movementInput[2]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][2]["spread_translation"] = 0
			self.movementInput[2]["bullets"][2]["internal_cooldown"] = 1200
			self.movementInput[2]["bullets"][2]["delay"] = 0
			self.movementInput[2]["bullets"][2]["speed"] = 0
			self.movementInput[2]["bullets"][3] = {}
			self.movementInput[2]["bullets"][3]["type"] = 1
			self.movementInput[2]["bullets"][3]["i"] = 1
			self.movementInput[2]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][3]["spread_angle"] = 60
			self.movementInput[2]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][3]["spread_translation"] = -20
			self.movementInput[2]["bullets"][3]["internal_cooldown"] = 1200
			self.movementInput[2]["bullets"][3]["delay"] = 400
			self.movementInput[2]["bullets"][3]["speed"] = 0
			self.movementInput[2]["bullets"][4] = {}
			self.movementInput[2]["bullets"][4]["type"] = 1
			self.movementInput[2]["bullets"][4]["i"] = 1
			self.movementInput[2]["bullets"][4]["spread_type"] = "circular"
			self.movementInput[2]["bullets"][4]["spread_angle"] = 60
			self.movementInput[2]["bullets"][4]["spread_base"] = "zero"
			self.movementInput[2]["bullets"][4]["spread_translation"] = -40
			self.movementInput[2]["bullets"][4]["internal_cooldown"] = 1200
			self.movementInput[2]["bullets"][4]["delay"] = 800
			self.movementInput[2]["bullets"][4]["speed"] = 0
			self.movementInput[2]["bullets"][5] = {}
			self.movementInput[2]["bullets"][5]["type"] = 1
			self.movementInput[2]["bullets"][5]["i"] = 2
			self.movementInput[2]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[2]["bullets"][5]["spread_angle"] = 5
			self.movementInput[2]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[2]["bullets"][5]["spread_translation"] = 0
			self.movementInput[2]["bullets"][5]["internal_cooldown"] = 2500
			self.movementInput[2]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[2]["bullets"][5]["delay"] = -1500
			self.movementInput[2]["bullets"][5]["speed"] = 4500
			
			self.movementInput[3] = {}
			self.movementInput[3]["spell_name"] = "none"
			self.movementInput[3]["spell_card"] = "none"
			self.movementInput[3]["spell_length"] = 6000
			self.movementInput[3]["spell_totallength"] = 9500
			self.movementInput[3]["spell_type"] = "repeating"
			self.movementInput[3]["position"] = "RT"
			self.movementInput[3]["movement_pattern"] = "false"
			self.movementInput[3]["spell_hp_threshold"] = 170
			self.movementInput[3]["bullets"] = {}
			self.movementInput[3]["bullets"][1] = {}
			self.movementInput[3]["bullets"][1]["type"] = 1
			self.movementInput[3]["bullets"][1]["i"] = 1
			self.movementInput[3]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][1]["spread_angle"] = 60
			self.movementInput[3]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][1]["spread_translation"] = 0
			self.movementInput[3]["bullets"][1]["internal_cooldown"] = 1200
			self.movementInput[3]["bullets"][1]["delay"] = 0
			self.movementInput[3]["bullets"][1]["speed"] = 0
			self.movementInput[3]["bullets"][2] = {}
			self.movementInput[3]["bullets"][2]["type"] = 1
			self.movementInput[3]["bullets"][2]["i"] = 1
			self.movementInput[3]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][2]["spread_angle"] = 60
			self.movementInput[3]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][2]["spread_translation"] = -20
			self.movementInput[3]["bullets"][2]["internal_cooldown"] = 1200
			self.movementInput[3]["bullets"][2]["delay"] = 400
			self.movementInput[3]["bullets"][2]["speed"] = 0
			self.movementInput[3]["bullets"][3] = {}
			self.movementInput[3]["bullets"][3]["type"] = 1
			self.movementInput[3]["bullets"][3]["i"] = 1
			self.movementInput[3]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[3]["bullets"][3]["spread_angle"] = 60
			self.movementInput[3]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[3]["bullets"][3]["spread_translation"] = -40
			self.movementInput[3]["bullets"][3]["internal_cooldown"] = 1200
			self.movementInput[3]["bullets"][3]["delay"] = 800
			self.movementInput[3]["bullets"][3]["speed"] = 0
			self.movementInput[3]["bullets"][4] = {}
			self.movementInput[3]["bullets"][4]["type"] = 1
			self.movementInput[3]["bullets"][4]["i"] = 2
			self.movementInput[3]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][4]["spread_angle"] = 5
			self.movementInput[3]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][4]["spread_translation"] = 0
			self.movementInput[3]["bullets"][4]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][4]["shotgun_frags"] = 1
			self.movementInput[3]["bullets"][4]["delay"] = -1500
			self.movementInput[3]["bullets"][4]["speed"] = 3600
			self.movementInput[3]["bullets"][5] = {}
			self.movementInput[3]["bullets"][5]["type"] = 1
			self.movementInput[3]["bullets"][5]["i"] = 2
			self.movementInput[3]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][5]["spread_angle"] = 10
			self.movementInput[3]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][5]["spread_translation"] = 0
			self.movementInput[3]["bullets"][5]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[3]["bullets"][5]["delay"] = -1300
			self.movementInput[3]["bullets"][5]["speed"] = 3800
			self.movementInput[3]["bullets"][6] = {}
			self.movementInput[3]["bullets"][6]["type"] = 1
			self.movementInput[3]["bullets"][6]["i"] = 2
			self.movementInput[3]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[3]["bullets"][6]["spread_angle"] = 15
			self.movementInput[3]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[3]["bullets"][6]["spread_translation"] = 0
			self.movementInput[3]["bullets"][6]["internal_cooldown"] = 3000
			self.movementInput[3]["bullets"][6]["shotgun_frags"] = 3
			self.movementInput[3]["bullets"][6]["delay"] = -1100
			self.movementInput[3]["bullets"][6]["speed"] = 4000
			
			self.movementInput[4] = {}
			self.movementInput[4]["spell_name"] = "Disasterous Rain"
			self.movementInput[4]["spell_card"] = "2"
			self.movementInput[4]["spell_length"] = 25000
			self.movementInput[4]["spell_totallength"] = 32000
			self.movementInput[4]["spell_type"] = "main"
			self.movementInput[4]["position"] = "MT"
			self.movementInput[4]["movement_pattern"] = "false"
			self.movementInput[4]["bullets"] = {}
			self.movementInput[4]["bullets"][1] = {}
			self.movementInput[4]["bullets"][1]["type"] = 1
			self.movementInput[4]["bullets"][1]["i"] = 1
			self.movementInput[4]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][1]["spread_angle"] = 0
			self.movementInput[4]["bullets"][1]["spread_distance"] = 128
			self.movementInput[4]["bullets"][1]["spread_interval"] = 72
			self.movementInput[4]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[4]["bullets"][1]["behaviour"] = 0 --bullet behaviour
			self.movementInput[4]["bullets"][1]["internal_cooldown"] = 2000
			self.movementInput[4]["bullets"][1]["delay"] = -2000
			self.movementInput[4]["bullets"][1]["speed"] = 6000
			self.movementInput[4]["bullets"][2] = {}
			self.movementInput[4]["bullets"][2]["type"] = 4 -- meteor
			self.movementInput[4]["bullets"][2]["i"] = 2
			self.movementInput[4]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][2]["spread_angle"] = 0
			self.movementInput[4]["bullets"][2]["spread_distance"] = 468
			self.movementInput[4]["bullets"][2]["spread_interval"] = 192
			self.movementInput[4]["bullets"][2]["spread_dstart"] = 128
			self.movementInput[4]["bullets"][2]["behaviour"] = 0
			self.movementInput[4]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[4]["bullets"][2]["delay"] = -2900
			self.movementInput[4]["bullets"][2]["speed"] = 3000
			self.movementInput[4]["bullets"][3] = {}
			self.movementInput[4]["bullets"][3]["type"] = 1
			self.movementInput[4]["bullets"][3]["i"] = 1
			self.movementInput[4]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[4]["bullets"][3]["spread_origin"] = "top"
			self.movementInput[4]["bullets"][3]["spread_angle"] = 0
			self.movementInput[4]["bullets"][3]["spread_distance"] = 128
			self.movementInput[4]["bullets"][3]["spread_interval"] = 56
			self.movementInput[4]["bullets"][3]["spread_dstart"] = 68
			self.movementInput[4]["bullets"][3]["behaviour"] = 0
			self.movementInput[4]["bullets"][3]["internal_cooldown"] = 2000
			self.movementInput[4]["bullets"][3]["delay"] = -1000
			self.movementInput[4]["bullets"][3]["speed"] = 6000
			
			self.movementInput[5] = {}
			self.movementInput[5]["spell_name"] = "none"
			self.movementInput[5]["spell_card"] = "none"
			self.movementInput[5]["spell_length"] = 4000
			self.movementInput[5]["spell_totallength"] = 8000
			self.movementInput[5]["spell_type"] = "repeating"
			self.movementInput[5]["position"] = "LT"
			self.movementInput[5]["movement_pattern"] = "false"
			self.movementInput[5]["spell_hp_threshold"] = 155
			self.movementInput[5]["bullets"] = {}
			self.movementInput[5]["bullets"][1] = {}
			self.movementInput[5]["bullets"][1]["type"] = 1
			self.movementInput[5]["bullets"][1]["i"] = 1
			self.movementInput[5]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][1]["spread_origin"] = "left"
			self.movementInput[5]["bullets"][1]["spread_angle"] = 0
			self.movementInput[5]["bullets"][1]["spread_distance"] = 64
			self.movementInput[5]["bullets"][1]["spread_interval"] = 0
			self.movementInput[5]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][1]["behaviour"] = 0
			self.movementInput[5]["bullets"][1]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][1]["delay"] = -1500
			self.movementInput[5]["bullets"][1]["speed"] = 6000
			self.movementInput[5]["bullets"][2] = {}
			self.movementInput[5]["bullets"][2]["type"] = 1
			self.movementInput[5]["bullets"][2]["i"] = 1
			self.movementInput[5]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][2]["spread_origin"] = "right"
			self.movementInput[5]["bullets"][2]["spread_angle"] = 0
			self.movementInput[5]["bullets"][2]["spread_distance"] = 64
			self.movementInput[5]["bullets"][2]["spread_interval"] = 0
			self.movementInput[5]["bullets"][2]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][2]["behaviour"] = 0
			self.movementInput[5]["bullets"][2]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][2]["delay"] = -1500
			self.movementInput[5]["bullets"][2]["speed"] = 6000
			self.movementInput[5]["bullets"][3] = {}
			self.movementInput[5]["bullets"][3]["type"] = 1
			self.movementInput[5]["bullets"][3]["i"] = 1
			self.movementInput[5]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][3]["spread_origin"] = "top"
			self.movementInput[5]["bullets"][3]["spread_angle"] = 0
			self.movementInput[5]["bullets"][3]["spread_distance"] = 64
			self.movementInput[5]["bullets"][3]["spread_interval"] = 0
			self.movementInput[5]["bullets"][3]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][3]["behaviour"] = 0
			self.movementInput[5]["bullets"][3]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][3]["delay"] = -3900
			self.movementInput[5]["bullets"][3]["speed"] = 6000
			self.movementInput[5]["bullets"][4] = {}
			self.movementInput[5]["bullets"][4]["type"] = 1
			self.movementInput[5]["bullets"][4]["i"] = 1
			self.movementInput[5]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[5]["bullets"][4]["spread_origin"] = "bottom"
			self.movementInput[5]["bullets"][4]["spread_angle"] = 0
			self.movementInput[5]["bullets"][4]["spread_distance"] = 64
			self.movementInput[5]["bullets"][4]["spread_interval"] = 0
			self.movementInput[5]["bullets"][4]["spread_dstart"] = 0
			self.movementInput[5]["bullets"][4]["behaviour"] = 0
			self.movementInput[5]["bullets"][4]["internal_cooldown"] = 4000
			self.movementInput[5]["bullets"][4]["delay"] = -1500
			self.movementInput[5]["bullets"][4]["speed"] = 6000
			self.movementInput[5]["bullets"][5] = {}
			self.movementInput[5]["bullets"][5]["type"] = 1
			self.movementInput[5]["bullets"][5]["i"] = 2
			self.movementInput[5]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][5]["spread_angle"] = 30
			self.movementInput[5]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][5]["spread_translation"] = 0
			self.movementInput[5]["bullets"][5]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][5]["delay"] = -6000
			self.movementInput[5]["bullets"][5]["speed"] = 5000
			self.movementInput[5]["bullets"][6] = {}
			self.movementInput[5]["bullets"][6]["type"] = 1
			self.movementInput[5]["bullets"][6]["i"] = 2
			self.movementInput[5]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][6]["spread_angle"] = 30
			self.movementInput[5]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][6]["spread_translation"] = 0
			self.movementInput[5]["bullets"][6]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][6]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][6]["delay"] = -5500
			self.movementInput[5]["bullets"][6]["speed"] = 5000
			self.movementInput[5]["bullets"][7] = {}
			self.movementInput[5]["bullets"][7]["type"] = 1
			self.movementInput[5]["bullets"][7]["i"] = 2
			self.movementInput[5]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][7]["spread_angle"] = 30
			self.movementInput[5]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][7]["spread_translation"] = 0
			self.movementInput[5]["bullets"][7]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][7]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][7]["delay"] = -5000
			self.movementInput[5]["bullets"][7]["speed"] = 5000
			self.movementInput[5]["bullets"][8] = {}
			self.movementInput[5]["bullets"][8]["type"] = 1
			self.movementInput[5]["bullets"][8]["i"] = 2
			self.movementInput[5]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[5]["bullets"][8]["spread_angle"] = 30
			self.movementInput[5]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[5]["bullets"][8]["spread_translation"] = 0
			self.movementInput[5]["bullets"][8]["internal_cooldown"] = 6000
			self.movementInput[5]["bullets"][8]["shotgun_frags"] = 2
			self.movementInput[5]["bullets"][8]["delay"] = -4500
			self.movementInput[5]["bullets"][8]["speed"] = 5000
			
			self.movementInput[6] = {}
			self.movementInput[6]["spell_name"] = "Tetragonal Thrust"
			self.movementInput[6]["spell_card"] = "2"
			self.movementInput[6]["spell_length"] = 25000
			self.movementInput[6]["spell_totallength"] = 27000
			self.movementInput[6]["spell_type"] = "main"
			self.movementInput[6]["position"] = "LB"
			self.movementInput[6]["movement_pattern"] = "false"
			self.movementInput[6]["bullets"] = {}
			self.movementInput[6]["bullets"][1] = {}
			self.movementInput[6]["bullets"][1]["type"] = 5
			self.movementInput[6]["bullets"][1]["i"] = 1
			self.movementInput[6]["bullets"][1]["spread_type"] = "clockwise"
			self.movementInput[6]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[6]["bullets"][1]["spread_dstart"] = 90
			self.movementInput[6]["bullets"][1]["internal_cooldown"] = 1200
			self.movementInput[6]["bullets"][1]["delay"] = -1200
			self.movementInput[6]["bullets"][1]["speed"] = 1000
			
			self.movementInput[7] = {}
			self.movementInput[7]["spell_name"] = "none"
			self.movementInput[7]["spell_card"] = "none"
			self.movementInput[7]["spell_length"] = 10000
			self.movementInput[7]["spell_totallength"] = 13000
			self.movementInput[7]["spell_type"] = "repeating"
			self.movementInput[7]["position"] = "LT"
			self.movementInput[7]["movement_pattern"] = "false"
			self.movementInput[7]["spell_hp_threshold"] = 140
			self.movementInput[7]["bullets"] = {}
			self.movementInput[7]["bullets"][1] = {}
			self.movementInput[7]["bullets"][1]["type"] = 5
			self.movementInput[7]["bullets"][1]["i"] = 1
			self.movementInput[7]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[7]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[7]["bullets"][1]["spread_angle"] = 0
			self.movementInput[7]["bullets"][1]["spread_distance"] = 320
			self.movementInput[7]["bullets"][1]["spread_interval"] = 64
			self.movementInput[7]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[7]["bullets"][1]["behaviour"] = 0
			self.movementInput[7]["bullets"][1]["internal_cooldown"] = 3000
			self.movementInput[7]["bullets"][1]["delay"] = -3000
			self.movementInput[7]["bullets"][1]["speed"] = 1000
			self.movementInput[7]["bullets"][2] = {}
			self.movementInput[7]["bullets"][2]["type"] = 1
			self.movementInput[7]["bullets"][2]["i"] = 2
			self.movementInput[7]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[7]["bullets"][2]["spread_angle"] = 15
			self.movementInput[7]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[7]["bullets"][2]["spread_translation"] = 0
			self.movementInput[7]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[7]["bullets"][2]["shotgun_frags"] = 7
			self.movementInput[7]["bullets"][2]["delay"] = -2000
			self.movementInput[7]["bullets"][2]["speed"] = 4000
			
			self.movementInput[8] = {}
			self.movementInput[8]["spell_name"] = "The World"
			self.movementInput[8]["spell_card"] = "2"
			self.movementInput[8]["spell_length"] = 42000
			self.movementInput[8]["spell_totallength"] = 46000
			self.movementInput[8]["spell_type"] = "main"
			self.movementInput[8]["position"] = "MT"
			self.movementInput[8]["movement_pattern"] = "false"
			self.movementInput[8]["bullets"] = {}
			self.movementInput[8]["bullets"][1] = {}
			self.movementInput[8]["bullets"][1]["spread_type"] = "timestop"
			self.movementInput[8]["bullets"][1]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][1]["length"] = 2000
			self.movementInput[8]["bullets"][1]["delay"] = -2000
			
			self.movementInput[8]["bullets"][2] = {}
			self.movementInput[8]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][2]["i"] = 1
			self.movementInput[8]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][2]["spread_angle"] = 12
			self.movementInput[8]["bullets"][2]["spread_translation"] = 0 -- arc difference from base direction
			self.movementInput[8]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][2]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][2]["speed"] = 4000
			
			self.movementInput[8]["bullets"][3] = {}
			self.movementInput[8]["bullets"][3]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][3]["i"] = 2
			self.movementInput[8]["bullets"][3]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][3]["spread_angle"] = 12
			self.movementInput[8]["bullets"][3]["spread_translation"] = 3 -- arc difference from base direction
			self.movementInput[8]["bullets"][3]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][3]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][3]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][3]["speed"] = 5500
			
			self.movementInput[8]["bullets"][4] = {}
			self.movementInput[8]["bullets"][4]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][4]["i"] = 3
			self.movementInput[8]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][4]["spread_angle"] = 12
			self.movementInput[8]["bullets"][4]["spread_translation"] = 6 -- arc difference from base direction
			self.movementInput[8]["bullets"][4]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][4]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][4]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][4]["speed"] = 7000
			
			self.movementInput[8]["bullets"][9] = {}
			self.movementInput[8]["bullets"][9]["type"] = 1 -- smarts
			self.movementInput[8]["bullets"][9]["i"] = 4
			self.movementInput[8]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][9]["spread_angle"] = 12
			self.movementInput[8]["bullets"][9]["spread_translation"] = 9 -- arc difference from base direction
			self.movementInput[8]["bullets"][9]["internal_cooldown"] = 2000
			self.movementInput[8]["bullets"][9]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][9]["delay"] = -1950 -- delay from spell start
			self.movementInput[8]["bullets"][9]["speed"] = 9000
			
			self.movementInput[8]["bullets"][5] = {}
			self.movementInput[8]["bullets"][5]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][5]["i"] = 1
			self.movementInput[8]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][5]["spread_angle"] = 6
			self.movementInput[8]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][5]["tsdistance"] = 96
			self.movementInput[8]["bullets"][5]["spread_translation"] = -1
			self.movementInput[8]["bullets"][5]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][5]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][5]["delay"] = -1900
			self.movementInput[8]["bullets"][5]["speed"] = 2000
			
			self.movementInput[8]["bullets"][6] = {}
			self.movementInput[8]["bullets"][6]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][6]["i"] = 1
			self.movementInput[8]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][6]["spread_angle"] = 6
			self.movementInput[8]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][6]["tsdistance"] = 160
			self.movementInput[8]["bullets"][6]["spread_translation"] = 2
			self.movementInput[8]["bullets"][6]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][6]["shotgun_frags"] = 6
			self.movementInput[8]["bullets"][6]["delay"] = -1800
			self.movementInput[8]["bullets"][6]["speed"] = 2000
			
			self.movementInput[8]["bullets"][7] = {}
			self.movementInput[8]["bullets"][7]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][7]["i"] = 1
			self.movementInput[8]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][7]["spread_angle"] = 3
			self.movementInput[8]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][7]["tsdistance"] = 224
			self.movementInput[8]["bullets"][7]["spread_translation"] = -10
			self.movementInput[8]["bullets"][7]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][7]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][7]["delay"] = -1750
			self.movementInput[8]["bullets"][7]["speed"] = 2000
			
			self.movementInput[8]["bullets"][8] = {}
			self.movementInput[8]["bullets"][8]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][8]["i"] = 1
			self.movementInput[8]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][8]["spread_angle"] = 3
			self.movementInput[8]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][8]["tsdistance"] = 288
			self.movementInput[8]["bullets"][8]["spread_translation"] = 10
			self.movementInput[8]["bullets"][8]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][8]["delay"] = -1700
			self.movementInput[8]["bullets"][8]["speed"] = 2000
			
			self.movementInput[8]["bullets"][10] = {}
			self.movementInput[8]["bullets"][10]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][10]["i"] = 1
			self.movementInput[8]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][10]["spread_angle"] = 3
			self.movementInput[8]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][10]["tsdistance"] = 332
			self.movementInput[8]["bullets"][10]["spread_translation"] = -10
			self.movementInput[8]["bullets"][10]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][10]["shotgun_frags"] = 3
			self.movementInput[8]["bullets"][10]["delay"] = -1650
			self.movementInput[8]["bullets"][10]["speed"] = 2000
			
			self.movementInput[8]["bullets"][11] = {}
			self.movementInput[8]["bullets"][11]["type"] = 6 -- time stop bullet
			self.movementInput[8]["bullets"][11]["i"] = 1
			self.movementInput[8]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[8]["bullets"][11]["spread_angle"] = 5
			self.movementInput[8]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[8]["bullets"][11]["tsdistance"] = 416
			self.movementInput[8]["bullets"][11]["spread_translation"] = 0
			self.movementInput[8]["bullets"][11]["internal_cooldown"] = 8000
			self.movementInput[8]["bullets"][11]["shotgun_frags"] = 10
			self.movementInput[8]["bullets"][11]["delay"] = -1600
			self.movementInput[8]["bullets"][11]["speed"] = 2000
			
			local dd = 0
			self.movementInput[9] = {}
			self.movementInput[9]["spell_name"] = "none"
			self.movementInput[9]["spell_card"] = "none"
			self.movementInput[9]["spell_length"] = 4000
			self.movementInput[9]["spell_totallength"] = 10000
			self.movementInput[9]["spell_type"] = "repeating"
			self.movementInput[9]["position"] = "RB"
			self.movementInput[9]["movement_pattern"] = "false"
			self.movementInput[9]["spell_hp_threshold"] = 125
			self.movementInput[9]["bullets"] = {}
			self.movementInput[9]["bullets"][1] = {}
			self.movementInput[9]["bullets"][1]["type"] = 1
			self.movementInput[9]["bullets"][1]["i"] = 1
			self.movementInput[9]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][1]["spread_angle"] = 5 + dd
			self.movementInput[9]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][1]["spread_translation"] = 0
			self.movementInput[9]["bullets"][1]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][1]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][1]["delay"] = -4000
			self.movementInput[9]["bullets"][1]["speed"] = 4000
			self.movementInput[9]["bullets"][2] = {}
			self.movementInput[9]["bullets"][2]["type"] = 1
			self.movementInput[9]["bullets"][2]["i"] = 1
			self.movementInput[9]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][2]["spread_angle"] = 6 + dd
			self.movementInput[9]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][2]["spread_translation"] = 0
			self.movementInput[9]["bullets"][2]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][2]["delay"] = -3800
			self.movementInput[9]["bullets"][2]["speed"] = 4000
			self.movementInput[9]["bullets"][3] = {}
			self.movementInput[9]["bullets"][3]["type"] = 1
			self.movementInput[9]["bullets"][3]["i"] = 1
			self.movementInput[9]["bullets"][3]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][3]["spread_angle"] = 8 + dd
			self.movementInput[9]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][3]["spread_translation"] = 0
			self.movementInput[9]["bullets"][3]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][3]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][3]["delay"] = -3600
			self.movementInput[9]["bullets"][3]["speed"] = 4000
			self.movementInput[9]["bullets"][4] = {}
			self.movementInput[9]["bullets"][4]["type"] = 1
			self.movementInput[9]["bullets"][4]["i"] = 1
			self.movementInput[9]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][4]["spread_angle"] = 10 + dd
			self.movementInput[9]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][4]["spread_translation"] = 0
			self.movementInput[9]["bullets"][4]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][4]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][4]["delay"] = -3400
			self.movementInput[9]["bullets"][4]["speed"] = 4000
			self.movementInput[9]["bullets"][5] = {}
			self.movementInput[9]["bullets"][5]["type"] = 1
			self.movementInput[9]["bullets"][5]["i"] = 1
			self.movementInput[9]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][5]["spread_angle"] = 13 + dd
			self.movementInput[9]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][5]["spread_translation"] = 0
			self.movementInput[9]["bullets"][5]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][5]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][5]["delay"] = -3200
			self.movementInput[9]["bullets"][5]["speed"] = 4000
			self.movementInput[9]["bullets"][6] = {}
			self.movementInput[9]["bullets"][6]["type"] = 1
			self.movementInput[9]["bullets"][6]["i"] = 1
			self.movementInput[9]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][6]["spread_angle"] = 16 + dd
			self.movementInput[9]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][6]["spread_translation"] = 0
			self.movementInput[9]["bullets"][6]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][6]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][6]["delay"] = -3000
			self.movementInput[9]["bullets"][6]["speed"] = 4000
			self.movementInput[9]["bullets"][7] = {}
			self.movementInput[9]["bullets"][7]["type"] = 1
			self.movementInput[9]["bullets"][7]["i"] = 1
			self.movementInput[9]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][7]["spread_angle"] = 18 + dd
			self.movementInput[9]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][7]["spread_translation"] = 0
			self.movementInput[9]["bullets"][7]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][7]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][7]["delay"] = -2800
			self.movementInput[9]["bullets"][7]["speed"] = 4000
			self.movementInput[9]["bullets"][8] = {}
			self.movementInput[9]["bullets"][8]["type"] = 1
			self.movementInput[9]["bullets"][8]["i"] = 1
			self.movementInput[9]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][8]["spread_angle"] = 20 + dd
			self.movementInput[9]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][8]["spread_translation"] = 0
			self.movementInput[9]["bullets"][8]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][8]["delay"] = -2600
			self.movementInput[9]["bullets"][8]["speed"] = 4000
			self.movementInput[9]["bullets"][9] = {}
			self.movementInput[9]["bullets"][9]["type"] = 1
			self.movementInput[9]["bullets"][9]["i"] = 1
			self.movementInput[9]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][9]["spread_angle"] = 21 + dd
			self.movementInput[9]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][9]["spread_translation"] = 0
			self.movementInput[9]["bullets"][9]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][9]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][9]["delay"] = -2400
			self.movementInput[9]["bullets"][9]["speed"] = 4000
			self.movementInput[9]["bullets"][10] = {}
			self.movementInput[9]["bullets"][10]["type"] = 1
			self.movementInput[9]["bullets"][10]["i"] = 1
			self.movementInput[9]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][10]["spread_angle"] = 22 + dd
			self.movementInput[9]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][10]["spread_translation"] = 0
			self.movementInput[9]["bullets"][10]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][10]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][10]["delay"] = -2200
			self.movementInput[9]["bullets"][10]["speed"] = 4000
			self.movementInput[9]["bullets"][11] = {}
			self.movementInput[9]["bullets"][11]["type"] = 1
			self.movementInput[9]["bullets"][11]["i"] = 1
			self.movementInput[9]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][11]["spread_angle"] = 22 + dd
			self.movementInput[9]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][11]["spread_translation"] = 0
			self.movementInput[9]["bullets"][11]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][11]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][11]["delay"] = -2000
			self.movementInput[9]["bullets"][11]["speed"] = 4000
			
			self.movementInput[9]["bullets"][12] = {}
			self.movementInput[9]["bullets"][12]["type"] = 1
			self.movementInput[9]["bullets"][12]["i"] = 1
			self.movementInput[9]["bullets"][12]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][12]["spread_angle"] = 21 + dd
			self.movementInput[9]["bullets"][12]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][12]["spread_translation"] = 0
			self.movementInput[9]["bullets"][12]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][12]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][12]["delay"] = -1800
			self.movementInput[9]["bullets"][12]["speed"] = 4000
			
			self.movementInput[9]["bullets"][13] = {}
			self.movementInput[9]["bullets"][13]["type"] = 1
			self.movementInput[9]["bullets"][13]["i"] = 1
			self.movementInput[9]["bullets"][13]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][13]["spread_angle"] = 20 + dd
			self.movementInput[9]["bullets"][13]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][13]["spread_translation"] = 0
			self.movementInput[9]["bullets"][13]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][13]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][13]["delay"] = -1600
			self.movementInput[9]["bullets"][13]["speed"] = 4000
			
			self.movementInput[9]["bullets"][14] = {}
			self.movementInput[9]["bullets"][14]["type"] = 1
			self.movementInput[9]["bullets"][14]["i"] = 1
			self.movementInput[9]["bullets"][14]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][14]["spread_angle"] = 18 + dd
			self.movementInput[9]["bullets"][14]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][14]["spread_translation"] = 0
			self.movementInput[9]["bullets"][14]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][14]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][14]["delay"] = -1400
			self.movementInput[9]["bullets"][14]["speed"] = 4000
			
			self.movementInput[9]["bullets"][15] = {}
			self.movementInput[9]["bullets"][15]["type"] = 1
			self.movementInput[9]["bullets"][15]["i"] = 1
			self.movementInput[9]["bullets"][15]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][15]["spread_angle"] = 16 + dd
			self.movementInput[9]["bullets"][15]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][15]["spread_translation"] = 0
			self.movementInput[9]["bullets"][15]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][15]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][15]["delay"] = -1200
			self.movementInput[9]["bullets"][15]["speed"] = 4000
			
			self.movementInput[9]["bullets"][16] = {}
			self.movementInput[9]["bullets"][16]["type"] = 1
			self.movementInput[9]["bullets"][16]["i"] = 1
			self.movementInput[9]["bullets"][16]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][16]["spread_angle"] = 13 + dd
			self.movementInput[9]["bullets"][16]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][16]["spread_translation"] = 0
			self.movementInput[9]["bullets"][16]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][16]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][16]["delay"] = -1000
			self.movementInput[9]["bullets"][16]["speed"] = 4000
			
			self.movementInput[9]["bullets"][17] = {}
			self.movementInput[9]["bullets"][17]["type"] = 1
			self.movementInput[9]["bullets"][17]["i"] = 1
			self.movementInput[9]["bullets"][17]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][17]["spread_angle"] = 10 + dd
			self.movementInput[9]["bullets"][17]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][17]["spread_translation"] = 0
			self.movementInput[9]["bullets"][17]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][17]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][17]["delay"] = -800
			self.movementInput[9]["bullets"][17]["speed"] = 4000
			
			self.movementInput[9]["bullets"][18] = {}
			self.movementInput[9]["bullets"][18]["type"] = 1
			self.movementInput[9]["bullets"][18]["i"] = 1
			self.movementInput[9]["bullets"][18]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][18]["spread_angle"] = 8 + dd
			self.movementInput[9]["bullets"][18]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][18]["spread_translation"] = 0
			self.movementInput[9]["bullets"][18]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][18]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][18]["delay"] = -600
			self.movementInput[9]["bullets"][18]["speed"] = 4000
			
			self.movementInput[9]["bullets"][19] = {}
			self.movementInput[9]["bullets"][19]["type"] = 1
			self.movementInput[9]["bullets"][19]["i"] = 1
			self.movementInput[9]["bullets"][19]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][19]["spread_angle"] = 7 + dd
			self.movementInput[9]["bullets"][19]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][19]["spread_translation"] = 0
			self.movementInput[9]["bullets"][19]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][19]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][19]["delay"] = -400
			self.movementInput[9]["bullets"][19]["speed"] = 4000
			
			self.movementInput[9]["bullets"][20] = {}
			self.movementInput[9]["bullets"][20]["type"] = 1
			self.movementInput[9]["bullets"][20]["i"] = 1
			self.movementInput[9]["bullets"][20]["spread_type"] = "shotgun"
			self.movementInput[9]["bullets"][20]["spread_angle"] = 6 + dd
			self.movementInput[9]["bullets"][20]["spread_base"] = "claw"
			self.movementInput[9]["bullets"][20]["spread_translation"] = 0
			self.movementInput[9]["bullets"][20]["internal_cooldown"] = 4200
			self.movementInput[9]["bullets"][20]["shotgun_frags"] = 3
			self.movementInput[9]["bullets"][20]["delay"] = -200
			self.movementInput[9]["bullets"][20]["speed"] = 4000
			
			
			self.movementInput[10] = {}
			self.movementInput[10]["spell_name"] = "Eldritch Epiphany"
			self.movementInput[10]["spell_card"] = "2"
			self.movementInput[10]["spell_length"] = 42000
			self.movementInput[10]["spell_totallength"] = 48000
			self.movementInput[10]["spell_type"] = "main"
			self.movementInput[10]["position"] = "LB"
			self.movementInput[10]["movement_pattern"] = "false"
			self.movementInput[10]["bullets"] = {}
			self.movementInput[10]["bullets"][1] = {}
			self.movementInput[10]["bullets"][1]["type"] = 7
			self.movementInput[10]["bullets"][1]["i"] = 2
			self.movementInput[10]["bullets"][1]["spread_type"] = "orbit"
			self.movementInput[10]["bullets"][1]["spread_angle"] = 30
			self.movementInput[10]["bullets"][1]["spread_distance"] = 128
			self.movementInput[10]["bullets"][1]["internal_cooldown"] = 50000
			self.movementInput[10]["bullets"][1]["delay"] = -50000
			self.movementInput[10]["bullets"][1]["speed"] = 0
			
			self.movementInput[10]["bullets"][2] = {}
			self.movementInput[10]["bullets"][2]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][2]["i"] = 5
			self.movementInput[10]["bullets"][2]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][2]["spread_base"] = "boundaries"
			self.movementInput[10]["bullets"][2]["repeats"] = 1
			self.movementInput[10]["bullets"][2]["internal_cooldown"] = 500
			self.movementInput[10]["bullets"][2]["delay"] = 0
			self.movementInput[10]["bullets"][2]["speed"] = 0
			
			self.movementInput[10]["bullets"][4] = {}
			self.movementInput[10]["bullets"][4]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][4]["i"] = 5
			self.movementInput[10]["bullets"][4]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][4]["spread_base"] = "proximity"
			self.movementInput[10]["bullets"][4]["repeats"] = 1
			self.movementInput[10]["bullets"][4]["internal_cooldown"] = 400
			self.movementInput[10]["bullets"][4]["delay"] = 0
			self.movementInput[10]["bullets"][4]["speed"] = 0
			self.movementInput[10]["bullets"][5] = {}
			self.movementInput[10]["bullets"][5]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][5]["i"] = 5
			self.movementInput[10]["bullets"][5]["spread_type"] = "fall"
			self.movementInput[10]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[10]["bullets"][5]["repeats"] = 1
			self.movementInput[10]["bullets"][5]["internal_cooldown"] = 2000
			self.movementInput[10]["bullets"][5]["delay"] = 50
			self.movementInput[10]["bullets"][5]["speed"] = 0
			
			self.movementInput[10]["bullets"][3] = {}
			self.movementInput[10]["bullets"][3]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[10]["bullets"][3]["i"] = 4
			self.movementInput[10]["bullets"][3]["spread_type"] = "pulsar"
			self.movementInput[10]["bullets"][3]["spread_angle"] = 180
			self.movementInput[10]["bullets"][3]["spread_interval"] = 11
			self.movementInput[10]["bullets"][3]["spread_dstart"] = 0
			self.movementInput[10]["bullets"][3]["spread_translation"] = 0
			self.movementInput[10]["bullets"][3]["internal_cooldown"] = 330
			self.movementInput[10]["bullets"][3]["delay"] = 2000
			self.movementInput[10]["bullets"][3]["speed"] = 3000
			
			
			
			self.movementInput[11] = {}
			self.movementInput[11]["spell_name"] = "none"
			self.movementInput[11]["spell_card"] = "none"
			self.movementInput[11]["spell_length"] = 3000
			self.movementInput[11]["spell_totallength"] = 5500
			self.movementInput[11]["spell_type"] = "repeating"
			self.movementInput[11]["position"] = "MB"
			self.movementInput[11]["movement_pattern"] = "false"
			self.movementInput[11]["spell_hp_threshold"] = 110
			self.movementInput[11]["bullets"] = {}
			self.movementInput[11]["bullets"][1] = {}
			self.movementInput[11]["bullets"][1]["type"] = 1 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[11]["bullets"][1]["i"] = 2
			self.movementInput[11]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[11]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[11]["bullets"][1]["spread_angle"] = 20
			self.movementInput[11]["bullets"][1]["spread_translation"] = 0
			self.movementInput[11]["bullets"][1]["internal_cooldown"] = 800
			self.movementInput[11]["bullets"][1]["delay"] = -600
			self.movementInput[11]["bullets"][1]["speed"] = 3500
			self.movementInput[11]["bullets"][2] = {}
			self.movementInput[11]["bullets"][2]["type"] = 1 -- smarts
			self.movementInput[11]["bullets"][2]["i"] = 1
			self.movementInput[11]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[11]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[11]["bullets"][2]["spread_angle"] = 20
			self.movementInput[11]["bullets"][2]["spread_translation"] = 10 -- arc difference from base direction
			self.movementInput[11]["bullets"][2]["internal_cooldown"] = 800
			self.movementInput[11]["bullets"][2]["delay"] = -200 -- delay from spell start
			self.movementInput[11]["bullets"][2]["speed"] = 0
			
			self.movementInput[12] = {}
			self.movementInput[12]["spell_name"] = "Endless Depth"
			self.movementInput[12]["spell_card"] = "2"
			self.movementInput[12]["spell_length"] = 25000
			self.movementInput[12]["spell_totallength"] = 28000
			self.movementInput[12]["spell_type"] = "main"
			self.movementInput[12]["position"] = "LB"
			self.movementInput[12]["movement_pattern"] = "false"
			self.movementInput[12]["bullets"] = {}
			
			self.movementInput[12]["bullets"][1] = {}
			self.movementInput[12]["bullets"][1]["type"] = 9
			self.movementInput[12]["bullets"][1]["i"] = 3
			self.movementInput[12]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[12]["bullets"][1]["spread_origin"] = "bottom"
			self.movementInput[12]["bullets"][1]["spread_angle"] = 0
			self.movementInput[12]["bullets"][1]["spread_distance"] = 64
			self.movementInput[12]["bullets"][1]["spread_interval"] = 32
			self.movementInput[12]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[12]["bullets"][1]["behaviour"] = 0
			self.movementInput[12]["bullets"][1]["internal_cooldown"] = 2000
			self.movementInput[12]["bullets"][1]["delay"] = -1600
			self.movementInput[12]["bullets"][1]["speed"] = 6000
			
			self.movementInput[13] = {}
			self.movementInput[13]["spell_name"] = "none"
			self.movementInput[13]["spell_card"] = "none"
			self.movementInput[13]["spell_length"] = 5000
			self.movementInput[13]["spell_totallength"] = 15000
			self.movementInput[13]["spell_type"] = "repeating"
			self.movementInput[13]["position"] = "MT"
			self.movementInput[13]["movement_pattern"] = "false"
			self.movementInput[13]["spell_hp_threshold"] = 95
			self.movementInput[13]["bullets"] = {}
			
			self.movementInput[13]["bullets"][1] = {}
			self.movementInput[13]["bullets"][1]["type"] = 1
			self.movementInput[13]["bullets"][1]["i"] = 1
			self.movementInput[13]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[13]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[13]["bullets"][1]["spread_angle"] = 0
			self.movementInput[13]["bullets"][1]["spread_distance"] = 965
			self.movementInput[13]["bullets"][1]["spread_interval"] = -32
			self.movementInput[13]["bullets"][1]["spread_dstart"] = 961
			self.movementInput[13]["bullets"][1]["behaviour"] = 1 --bullet behaviour
			self.movementInput[13]["bullets"][1]["internal_cooldown"] = 167
			self.movementInput[13]["bullets"][1]["delay"] = -166
			self.movementInput[13]["bullets"][1]["speed"] = 4500
			
			self.movementInput[13]["bullets"][2] = {}
			self.movementInput[13]["bullets"][2]["type"] = 1
			self.movementInput[13]["bullets"][2]["i"] = 1
			self.movementInput[13]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[13]["bullets"][2]["spread_origin"] = "bottom"
			self.movementInput[13]["bullets"][2]["spread_angle"] = 0
			self.movementInput[13]["bullets"][2]["spread_distance"] = 970
			self.movementInput[13]["bullets"][2]["spread_interval"] = 32
			self.movementInput[13]["bullets"][2]["spread_dstart"] = 1
			self.movementInput[13]["bullets"][2]["behaviour"] = 1 --bullet behaviour
			self.movementInput[13]["bullets"][2]["internal_cooldown"] = 167
			self.movementInput[13]["bullets"][2]["delay"] = -166
			self.movementInput[13]["bullets"][2]["speed"] = 4500
			
			self.movementInput[13]["bullets"][3] = {}
			self.movementInput[13]["bullets"][3]["type"] = 1
			self.movementInput[13]["bullets"][3]["i"] = 1
			self.movementInput[13]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[13]["bullets"][3]["spread_origin"] = "left"
			self.movementInput[13]["bullets"][3]["spread_angle"] = 0
			self.movementInput[13]["bullets"][3]["spread_distance"] = 1280
			self.movementInput[13]["bullets"][3]["spread_interval"] = -40
			self.movementInput[13]["bullets"][3]["spread_dstart"] = 1279
			self.movementInput[13]["bullets"][3]["behaviour"] = 1 --bullet behaviour
			self.movementInput[13]["bullets"][3]["internal_cooldown"] = 157
			self.movementInput[13]["bullets"][3]["delay"] = -157
			self.movementInput[13]["bullets"][3]["speed"] = 4500
			
			self.movementInput[13]["bullets"][4] = {}
			self.movementInput[13]["bullets"][4]["type"] = 1
			self.movementInput[13]["bullets"][4]["i"] = 1
			self.movementInput[13]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[13]["bullets"][4]["spread_origin"] = "right"
			self.movementInput[13]["bullets"][4]["spread_angle"] = 0
			self.movementInput[13]["bullets"][4]["spread_distance"] = 1280
			self.movementInput[13]["bullets"][4]["spread_interval"] = 40
			self.movementInput[13]["bullets"][4]["spread_dstart"] = 5
			self.movementInput[13]["bullets"][4]["behaviour"] = 1 --bullet behaviour
			self.movementInput[13]["bullets"][4]["internal_cooldown"] = 157
			self.movementInput[13]["bullets"][4]["delay"] = -157
			self.movementInput[13]["bullets"][4]["speed"] = 4500
			
			self.movementInput[14] = {}
			self.movementInput[14]["spell_name"] = "Boundary of Sea and Land"
			self.movementInput[14]["spell_card"] = "2"
			self.movementInput[14]["spell_length"] = 40000
			self.movementInput[14]["spell_totallength"] = 45000
			self.movementInput[14]["spell_type"] = "main"
			self.movementInput[14]["position"] = "LT"
			self.movementInput[14]["movement_pattern"] = "false"
			self.movementInput[14]["bullets"] = {}
			
			self.movementInput[14]["bullets"][1] = {}
			self.movementInput[14]["bullets"][1]["type"] = 1
			self.movementInput[14]["bullets"][1]["i"] = 1
			self.movementInput[14]["bullets"][1]["spread_type"] = "rain"
			self.movementInput[14]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[14]["bullets"][1]["spread_angle"] = 0
			self.movementInput[14]["bullets"][1]["spread_distance"] = 48
			self.movementInput[14]["bullets"][1]["spread_interval"] = 24
			self.movementInput[14]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[14]["bullets"][1]["behaviour"] = 2 --bullet behaviour
			self.movementInput[14]["bullets"][1]["internal_cooldown"] = 450
			self.movementInput[14]["bullets"][1]["delay"] = -450
			self.movementInput[14]["bullets"][1]["speed"] = 2700
			
			self.movementInput[15] = {}
			self.movementInput[15]["spell_name"] = "none"
			self.movementInput[15]["spell_card"] = "none"
			self.movementInput[15]["spell_length"] = 180
			self.movementInput[15]["spell_totallength"] = 5000
			self.movementInput[15]["spell_type"] = "repeating"
			self.movementInput[15]["position"] = "RT"
			self.movementInput[15]["movement_pattern"] = "false"
			self.movementInput[15]["spell_hp_threshold"] = 80
			self.movementInput[15]["bullets"] = {}
			self.movementInput[15]["bullets"][1] = {}
			self.movementInput[15]["bullets"][1]["type"] = 10
			self.movementInput[15]["bullets"][1]["i"] = 1
			self.movementInput[15]["bullets"][1]["spread_type"] = "clockwise"
			self.movementInput[15]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[15]["bullets"][1]["spread_dstart"] = 90
			self.movementInput[15]["bullets"][1]["internal_cooldown"] = 100
			self.movementInput[15]["bullets"][1]["delay"] = -180
			self.movementInput[15]["bullets"][1]["speed"] = 1000
			
			self.movementInput[16] = {}
			self.movementInput[16]["spell_name"] = "Spitfire"
			self.movementInput[16]["spell_card"] = "2"
			self.movementInput[16]["spell_length"] = 40000
			self.movementInput[16]["spell_totallength"] = 42000
			self.movementInput[16]["spell_type"] = "main"
			self.movementInput[16]["position"] = "MT"
			self.movementInput[16]["movement_pattern"] = "false"
			self.movementInput[16]["bullets"] = {}
			self.movementInput[16]["bullets"][1] = {}
			self.movementInput[16]["bullets"][1]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[16]["bullets"][1]["i"] = 1
			self.movementInput[16]["bullets"][1]["spread_type"] = "fall"
			self.movementInput[16]["bullets"][1]["spread_base"] = "boundaries"
			self.movementInput[16]["bullets"][1]["repeats"] = 2
			self.movementInput[16]["bullets"][1]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][1]["delay"] = -6500
			self.movementInput[16]["bullets"][1]["speed"] = 0
			self.movementInput[16]["bullets"][2] = {}
			self.movementInput[16]["bullets"][2]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[16]["bullets"][2]["i"] = 1
			self.movementInput[16]["bullets"][2]["spread_type"] = "fall"
			self.movementInput[16]["bullets"][2]["spread_base"] = "boundaries"
			self.movementInput[16]["bullets"][2]["repeats"] = 3
			self.movementInput[16]["bullets"][2]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][2]["delay"] = -6400
			self.movementInput[16]["bullets"][2]["speed"] = 0
			self.movementInput[16]["bullets"][3] = {}
			self.movementInput[16]["bullets"][3]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[16]["bullets"][3]["i"] = 1
			self.movementInput[16]["bullets"][3]["spread_type"] = "fall"
			self.movementInput[16]["bullets"][3]["spread_base"] = "boundaries"
			self.movementInput[16]["bullets"][3]["repeats"] = 4
			self.movementInput[16]["bullets"][3]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][3]["delay"] = -6300
			self.movementInput[16]["bullets"][3]["speed"] = 0
			
			self.movementInput[16]["bullets"][4] = {}
			self.movementInput[16]["bullets"][4]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[16]["bullets"][4]["i"] = 1
			self.movementInput[16]["bullets"][4]["spread_type"] = "fall"
			self.movementInput[16]["bullets"][4]["spread_base"] = "boundaries"
			self.movementInput[16]["bullets"][4]["repeats"] = 5
			self.movementInput[16]["bullets"][4]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][4]["delay"] = -6200
			self.movementInput[16]["bullets"][4]["speed"] = 0
			
			self.movementInput[16]["bullets"][5] = {}
			self.movementInput[16]["bullets"][5]["type"] = 8 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[16]["bullets"][5]["i"] = 1
			self.movementInput[16]["bullets"][5]["spread_type"] = "fall"
			self.movementInput[16]["bullets"][5]["spread_base"] = "boundaries"
			self.movementInput[16]["bullets"][5]["repeats"] = 6
			self.movementInput[16]["bullets"][5]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][5]["delay"] = -6100
			self.movementInput[16]["bullets"][5]["speed"] = 0
			
			self.movementInput[16]["bullets"][6] = {}
			self.movementInput[16]["bullets"][6]["type"] = 1
			self.movementInput[16]["bullets"][6]["i"] = 2
			self.movementInput[16]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][6]["spread_angle"] = 6
			self.movementInput[16]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][6]["spread_translation"] = 0
			self.movementInput[16]["bullets"][6]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][6]["shotgun_frags"] = 1
			self.movementInput[16]["bullets"][6]["delay"] = -2500
			self.movementInput[16]["bullets"][6]["speed"] = 1800
			self.movementInput[16]["bullets"][7] = {}
			self.movementInput[16]["bullets"][7]["type"] = 1
			self.movementInput[16]["bullets"][7]["i"] = 2
			self.movementInput[16]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][7]["spread_angle"] = 6
			self.movementInput[16]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][7]["spread_translation"] = 0
			self.movementInput[16]["bullets"][7]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][7]["shotgun_frags"] = 1
			self.movementInput[16]["bullets"][7]["delay"] = -2500
			self.movementInput[16]["bullets"][7]["speed"] = 2000
			self.movementInput[16]["bullets"][8] = {}
			self.movementInput[16]["bullets"][8]["type"] = 1
			self.movementInput[16]["bullets"][8]["i"] = 2
			self.movementInput[16]["bullets"][8]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][8]["spread_angle"] = 4
			self.movementInput[16]["bullets"][8]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][8]["spread_translation"] = 2
			self.movementInput[16]["bullets"][8]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][8]["shotgun_frags"] = 3
			self.movementInput[16]["bullets"][8]["delay"] = -2500
			self.movementInput[16]["bullets"][8]["speed"] = 2400
			self.movementInput[16]["bullets"][9] = {}
			self.movementInput[16]["bullets"][9]["type"] = 1
			self.movementInput[16]["bullets"][9]["i"] = 2
			self.movementInput[16]["bullets"][9]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][9]["spread_angle"] = 4
			self.movementInput[16]["bullets"][9]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][9]["spread_translation"] = 2
			self.movementInput[16]["bullets"][9]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][9]["shotgun_frags"] = 12
			self.movementInput[16]["bullets"][9]["delay"] = -2500
			self.movementInput[16]["bullets"][9]["speed"] = 2600
			self.movementInput[16]["bullets"][10] = {}
			self.movementInput[16]["bullets"][10]["type"] = 1
			self.movementInput[16]["bullets"][10]["i"] = 2
			self.movementInput[16]["bullets"][10]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][10]["spread_angle"] = 4
			self.movementInput[16]["bullets"][10]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][10]["spread_translation"] = 2
			self.movementInput[16]["bullets"][10]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][10]["shotgun_frags"] = 12
			self.movementInput[16]["bullets"][10]["delay"] = -2500
			self.movementInput[16]["bullets"][10]["speed"] = 2800
			self.movementInput[16]["bullets"][11] = {}
			self.movementInput[16]["bullets"][11]["type"] = 1
			self.movementInput[16]["bullets"][11]["i"] = 2
			self.movementInput[16]["bullets"][11]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][11]["spread_angle"] = 4
			self.movementInput[16]["bullets"][11]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][11]["spread_translation"] = 2
			self.movementInput[16]["bullets"][11]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][11]["shotgun_frags"] = 12
			self.movementInput[16]["bullets"][11]["delay"] = -2500
			self.movementInput[16]["bullets"][11]["speed"] = 3000
			self.movementInput[16]["bullets"][12] = {}
			self.movementInput[16]["bullets"][12]["type"] = 1
			self.movementInput[16]["bullets"][12]["i"] = 2
			self.movementInput[16]["bullets"][12]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][12]["spread_angle"] = 4
			self.movementInput[16]["bullets"][12]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][12]["spread_translation"] = 0
			self.movementInput[16]["bullets"][12]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][12]["shotgun_frags"] = 2
			self.movementInput[16]["bullets"][12]["delay"] = -2500
			self.movementInput[16]["bullets"][12]["speed"] = 3500
			self.movementInput[16]["bullets"][13] = {}
			self.movementInput[16]["bullets"][13]["type"] = 1
			self.movementInput[16]["bullets"][13]["i"] = 2
			self.movementInput[16]["bullets"][13]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][13]["spread_angle"] = 6
			self.movementInput[16]["bullets"][13]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][13]["spread_translation"] = 0
			self.movementInput[16]["bullets"][13]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][13]["shotgun_frags"] = 2
			self.movementInput[16]["bullets"][13]["delay"] = -2500
			self.movementInput[16]["bullets"][13]["speed"] = 3700
			self.movementInput[16]["bullets"][14] = {}
			self.movementInput[16]["bullets"][14]["type"] = 1
			self.movementInput[16]["bullets"][14]["i"] = 2
			self.movementInput[16]["bullets"][14]["spread_type"] = "shotgun"
			self.movementInput[16]["bullets"][14]["spread_angle"] = 4
			self.movementInput[16]["bullets"][14]["spread_base"] = "claw"
			self.movementInput[16]["bullets"][14]["spread_translation"] = 0
			self.movementInput[16]["bullets"][14]["internal_cooldown"] = 8000
			self.movementInput[16]["bullets"][14]["shotgun_frags"] = 3
			self.movementInput[16]["bullets"][14]["delay"] = -2500
			self.movementInput[16]["bullets"][14]["speed"] = 3900
			
			self.movementInput[17] = {}
			self.movementInput[17]["spell_name"] = "none"
			self.movementInput[17]["spell_card"] = "none"
			self.movementInput[17]["spell_length"] = 2000
			self.movementInput[17]["spell_totallength"] = 5000
			self.movementInput[17]["spell_type"] = "repeating"
			self.movementInput[17]["position"] = "LB"
			self.movementInput[17]["movement_pattern"] = "false"
			self.movementInput[17]["spell_hp_threshold"] = 65
			self.movementInput[17]["bullets"] = {}
			self.movementInput[17]["bullets"][1] = {}
			self.movementInput[17]["bullets"][1]["type"] = 11
			self.movementInput[17]["bullets"][1]["i"] = 3
			self.movementInput[17]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[17]["bullets"][1]["spread_angle"] = 0
			self.movementInput[17]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[17]["bullets"][1]["spread_translation"] = 0
			self.movementInput[17]["bullets"][1]["internal_cooldown"] = 200
			self.movementInput[17]["bullets"][1]["shotgun_frags"] = 1
			self.movementInput[17]["bullets"][1]["delay"] = 100
			self.movementInput[17]["bullets"][1]["speed"] = 2500
			self.movementInput[17]["bullets"][2] = {}
			self.movementInput[17]["bullets"][2]["type"] = 11
			self.movementInput[17]["bullets"][2]["i"] = 3
			self.movementInput[17]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[17]["bullets"][2]["spread_angle"] = 20
			self.movementInput[17]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[17]["bullets"][2]["spread_translation"] = 0
			self.movementInput[17]["bullets"][2]["internal_cooldown"] = 1000
			self.movementInput[17]["bullets"][2]["shotgun_frags"] = 3
			self.movementInput[17]["bullets"][2]["delay"] = -200
			self.movementInput[17]["bullets"][2]["speed"] = 2500
			
			self.movementInput[18] = {}
			self.movementInput[18]["spell_name"] = "Circle of Stars"
			self.movementInput[18]["spell_card"] = "2"
			self.movementInput[18]["spell_length"] = 42000
			self.movementInput[18]["spell_totallength"] = 44000
			self.movementInput[18]["spell_type"] = "main"
			self.movementInput[18]["position"] = "MT"
			self.movementInput[18]["movement_pattern"] = "false"
			self.movementInput[18]["bullets"] = {}
			self.movementInput[18]["bullets"][1] = {}
			self.movementInput[18]["bullets"][1]["type"] = 1
			self.movementInput[18]["bullets"][1]["i"] = 1
			self.movementInput[18]["bullets"][1]["spread_type"] = "hunterseeker"
			self.movementInput[18]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[18]["bullets"][1]["spread_angle"] = 0
			self.movementInput[18]["bullets"][1]["spread_distance"] = 320
			self.movementInput[18]["bullets"][1]["spread_interval"] = 64
			self.movementInput[18]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[18]["bullets"][1]["behaviour"] = 0
			self.movementInput[18]["bullets"][1]["duration"] = 42000
			self.movementInput[18]["bullets"][1]["internal_cooldown"] = 60000
			self.movementInput[18]["bullets"][1]["delay"] = -60000
			self.movementInput[18]["bullets"][1]["speed"] = 1000
			self.movementInput[18]["bullets"][2] = {}
			self.movementInput[18]["bullets"][2]["type"] = 2
			self.movementInput[18]["bullets"][2]["i"] = 1
			self.movementInput[18]["bullets"][2]["spread_type"] = "hunterseeker"
			self.movementInput[18]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[18]["bullets"][2]["spread_angle"] = 0
			self.movementInput[18]["bullets"][2]["spread_distance"] = 320
			self.movementInput[18]["bullets"][2]["spread_interval"] = 64
			self.movementInput[18]["bullets"][2]["spread_dstart"] = 0
			self.movementInput[18]["bullets"][2]["behaviour"] = 0
			self.movementInput[18]["bullets"][2]["duration"] = 21000
			self.movementInput[18]["bullets"][2]["internal_cooldown"] = 60000
			self.movementInput[18]["bullets"][2]["delay"] = -39000
			self.movementInput[18]["bullets"][2]["speed"] = 1000
			
			self.movementInput[19] = {}
			self.movementInput[19]["spell_name"] = "none"
			self.movementInput[19]["spell_card"] = "none"
			self.movementInput[19]["spell_length"] = 3000
			self.movementInput[19]["spell_totallength"] = 6500
			self.movementInput[19]["spell_type"] = "repeating"
			self.movementInput[19]["position"] = "RB"
			self.movementInput[19]["movement_pattern"] = "false"
			self.movementInput[19]["spell_hp_threshold"] = 50
			self.movementInput[19]["bullets"] = {}
			self.movementInput[19]["bullets"][1] = {}
			self.movementInput[19]["bullets"][1]["type"] = 12 -- bullet's (logic: Danmaku) smarts value
			self.movementInput[19]["bullets"][1]["i"] = 2
			self.movementInput[19]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[19]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[19]["bullets"][1]["spread_angle"] = 90
			self.movementInput[19]["bullets"][1]["spread_translation"] = 45
			self.movementInput[19]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[19]["bullets"][1]["delay"] = -900
			self.movementInput[19]["bullets"][1]["speed"] = 4000
			
			self.movementInput[20] = {}
			self.movementInput[20]["spell_name"] = "Opening the Eye"
			self.movementInput[20]["spell_card"] = "2"
			self.movementInput[20]["spell_length"] = 53000
			self.movementInput[20]["spell_totallength"] = 57000
			self.movementInput[20]["spell_type"] = "main"
			self.movementInput[20]["position"] = "LB"
			self.movementInput[20]["movement_pattern"] = "false"
			self.movementInput[20]["bullets"] = {}
			self.movementInput[20]["bullets"][1] = {}
			self.movementInput[20]["bullets"][1]["type"] = 2
			self.movementInput[20]["bullets"][1]["i"] = 1
			self.movementInput[20]["bullets"][1]["spread_type"] = "hunterseeker"
			self.movementInput[20]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[20]["bullets"][1]["spread_angle"] = 0
			self.movementInput[20]["bullets"][1]["spread_distance"] = 320
			self.movementInput[20]["bullets"][1]["spread_interval"] = 64
			self.movementInput[20]["bullets"][1]["spread_dstart"] = 0
			self.movementInput[20]["bullets"][1]["behaviour"] = 1
			self.movementInput[20]["bullets"][1]["duration"] = 52900
			self.movementInput[20]["bullets"][1]["internal_cooldown"] = 60000
			self.movementInput[20]["bullets"][1]["delay"] = -60000
			self.movementInput[20]["bullets"][1]["speed"] = 1000
			
			self.movementInput[20]["bullets"][2] = {}
			self.movementInput[20]["bullets"][2]["type"] = 13
			self.movementInput[20]["bullets"][2]["i"] = 3
			self.movementInput[20]["bullets"][2]["spread_type"] = "rain"
			self.movementInput[20]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[20]["bullets"][2]["spread_angle"] = 0
			self.movementInput[20]["bullets"][2]["spread_distance"] = 965
			self.movementInput[20]["bullets"][2]["spread_interval"] = -52
			self.movementInput[20]["bullets"][2]["spread_dstart"] = 961
			self.movementInput[20]["bullets"][2]["behaviour"] = 0 --bullet behaviour
			self.movementInput[20]["bullets"][2]["internal_cooldown"] = 120
			self.movementInput[20]["bullets"][2]["delay"] = -166
			self.movementInput[20]["bullets"][2]["speed"] = 3000
			
			self.movementInput[20]["bullets"][3] = {}
			self.movementInput[20]["bullets"][3]["type"] = 13
			self.movementInput[20]["bullets"][3]["i"] = 3
			self.movementInput[20]["bullets"][3]["spread_type"] = "rain"
			self.movementInput[20]["bullets"][3]["spread_origin"] = "bottom"
			self.movementInput[20]["bullets"][3]["spread_angle"] = 0
			self.movementInput[20]["bullets"][3]["spread_distance"] = 970
			self.movementInput[20]["bullets"][3]["spread_interval"] = 52
			self.movementInput[20]["bullets"][3]["spread_dstart"] = 1
			self.movementInput[20]["bullets"][3]["behaviour"] = 0 --bullet behaviour
			self.movementInput[20]["bullets"][3]["internal_cooldown"] = 120
			self.movementInput[20]["bullets"][3]["delay"] = -166
			self.movementInput[20]["bullets"][3]["speed"] = 3000
			
			self.movementInput[20]["bullets"][4] = {}
			self.movementInput[20]["bullets"][4]["type"] = 13
			self.movementInput[20]["bullets"][4]["i"] = 3
			self.movementInput[20]["bullets"][4]["spread_type"] = "rain"
			self.movementInput[20]["bullets"][4]["spread_origin"] = "left"
			self.movementInput[20]["bullets"][4]["spread_angle"] = 0
			self.movementInput[20]["bullets"][4]["spread_distance"] = 1280
			self.movementInput[20]["bullets"][4]["spread_interval"] = -52
			self.movementInput[20]["bullets"][4]["spread_dstart"] = 1279
			self.movementInput[20]["bullets"][4]["behaviour"] = 0 --bullet behaviour
			self.movementInput[20]["bullets"][4]["internal_cooldown"] = 110
			self.movementInput[20]["bullets"][4]["delay"] = -157
			self.movementInput[20]["bullets"][4]["speed"] = 3000
			
			self.movementInput[20]["bullets"][5] = {}
			self.movementInput[20]["bullets"][5]["type"] = 13
			self.movementInput[20]["bullets"][5]["i"] = 3
			self.movementInput[20]["bullets"][5]["spread_type"] = "rain"
			self.movementInput[20]["bullets"][5]["spread_origin"] = "right"
			self.movementInput[20]["bullets"][5]["spread_angle"] = 0
			self.movementInput[20]["bullets"][5]["spread_distance"] = 1280
			self.movementInput[20]["bullets"][5]["spread_interval"] = 52
			self.movementInput[20]["bullets"][5]["spread_dstart"] = 5
			self.movementInput[20]["bullets"][5]["behaviour"] = 0 --bullet behaviour
			self.movementInput[20]["bullets"][5]["internal_cooldown"] = 110
			self.movementInput[20]["bullets"][5]["delay"] = -157
			self.movementInput[20]["bullets"][5]["speed"] = 3000
			
			self.movementInput[21] = {}
			self.movementInput[21]["spell_name"] = "none"
			self.movementInput[21]["spell_card"] = "none"
			self.movementInput[21]["spell_length"] = 1800
			self.movementInput[21]["spell_totallength"] = 3000
			self.movementInput[21]["spell_type"] = "repeating"
			self.movementInput[21]["position"] = "LT"
			self.movementInput[21]["movement_pattern"] = "false"
			self.movementInput[21]["spell_hp_threshold"] = 35
			self.movementInput[21]["bullets"] = {}
			self.movementInput[21]["bullets"][1] = {}
			self.movementInput[21]["bullets"][1]["type"] = 2
			self.movementInput[21]["bullets"][1]["i"] = 1
			self.movementInput[21]["bullets"][1]["spread_type"] = "shotgun"
			self.movementInput[21]["bullets"][1]["spread_angle"] = 6
			self.movementInput[21]["bullets"][1]["spread_base"] = "claw"
			self.movementInput[21]["bullets"][1]["spread_translation"] = 52
			self.movementInput[21]["bullets"][1]["internal_cooldown"] = 2000
			self.movementInput[21]["bullets"][1]["shotgun_frags"] = 2
			self.movementInput[21]["bullets"][1]["delay"] = -2000
			self.movementInput[21]["bullets"][1]["speed"] = 3000
			self.movementInput[21]["bullets"][2] = {}
			self.movementInput[21]["bullets"][2]["type"] = 2
			self.movementInput[21]["bullets"][2]["i"] = 1
			self.movementInput[21]["bullets"][2]["spread_type"] = "shotgun"
			self.movementInput[21]["bullets"][2]["spread_angle"] = 6
			self.movementInput[21]["bullets"][2]["spread_base"] = "claw"
			self.movementInput[21]["bullets"][2]["spread_translation"] = 26
			self.movementInput[21]["bullets"][2]["internal_cooldown"] = 2000
			self.movementInput[21]["bullets"][2]["shotgun_frags"] = 2
			self.movementInput[21]["bullets"][2]["delay"] = -1750
			self.movementInput[21]["bullets"][2]["speed"] = 3000
			self.movementInput[21]["bullets"][3] = {}
			self.movementInput[21]["bullets"][3]["type"] = 2
			self.movementInput[21]["bullets"][3]["i"] = 1
			self.movementInput[21]["bullets"][3]["spread_type"] = "shotgun"
			self.movementInput[21]["bullets"][3]["spread_angle"] = 6
			self.movementInput[21]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[21]["bullets"][3]["spread_translation"] = 0
			self.movementInput[21]["bullets"][3]["internal_cooldown"] = 2000
			self.movementInput[21]["bullets"][3]["shotgun_frags"] = 2
			self.movementInput[21]["bullets"][3]["delay"] = -1500
			self.movementInput[21]["bullets"][3]["speed"] = 3000
			self.movementInput[21]["bullets"][4] = {}
			self.movementInput[21]["bullets"][4]["type"] = 2
			self.movementInput[21]["bullets"][4]["i"] = 1
			self.movementInput[21]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[21]["bullets"][4]["spread_angle"] = 6
			self.movementInput[21]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[21]["bullets"][4]["spread_translation"] = -26
			self.movementInput[21]["bullets"][4]["internal_cooldown"] = 2000
			self.movementInput[21]["bullets"][4]["shotgun_frags"] = 2
			self.movementInput[21]["bullets"][4]["delay"] = -1250
			self.movementInput[21]["bullets"][4]["speed"] = 3000
			self.movementInput[21]["bullets"][5] = {}
			self.movementInput[21]["bullets"][5]["type"] = 2
			self.movementInput[21]["bullets"][5]["i"] = 1
			self.movementInput[21]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[21]["bullets"][5]["spread_angle"] = 6
			self.movementInput[21]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[21]["bullets"][5]["spread_translation"] = -52
			self.movementInput[21]["bullets"][5]["internal_cooldown"] = 2000
			self.movementInput[21]["bullets"][5]["shotgun_frags"] = 2
			self.movementInput[21]["bullets"][5]["delay"] = -1000
			self.movementInput[21]["bullets"][5]["speed"] = 3000
			
			self.movementInput[22] = {}
			self.movementInput[22]["spell_name"] = "Shrine Part 1"
			self.movementInput[22]["spell_card"] = "2"
			self.movementInput[22]["spell_length"] = 22000
			self.movementInput[22]["spell_totallength"] = 25000
			self.movementInput[22]["spell_type"] = "main"
			self.movementInput[22]["position"] = "MB"
			self.movementInput[22]["movement_pattern"] = "false"
			self.movementInput[22]["bullets"] = {}
			self.movementInput[22]["bullets"][1] = {}
			self.movementInput[22]["bullets"][1]["type"] = 1
			self.movementInput[22]["bullets"][1]["i"] = 1
			self.movementInput[22]["bullets"][1]["spread_type"] = "camera"
			self.movementInput[22]["bullets"][1]["spread_base"] = "areti"
			self.movementInput[22]["bullets"][1]["internal_cooldown"] = 28000
			self.movementInput[22]["bullets"][1]["delay"] = 1000-28000
			self.movementInput[22]["bullets"][1]["speed"] = 0
			self.movementInput[22]["bullets"][2] = {}
			self.movementInput[22]["bullets"][2]["type"] = 1
			self.movementInput[22]["bullets"][2]["i"] = 1
			self.movementInput[22]["bullets"][2]["spread_type"] = "domain_expansion"
			self.movementInput[22]["bullets"][2]["internal_cooldown"] = 28000
			self.movementInput[22]["bullets"][2]["delay"] = 2500-28000
			self.movementInput[22]["bullets"][2]["speed"] = 0
			self.movementInput[22]["bullets"][3] = {}
			self.movementInput[22]["bullets"][3]["type"] = 1
			self.movementInput[22]["bullets"][3]["i"] = 1
			self.movementInput[22]["bullets"][3]["spread_type"] = "camera"
			self.movementInput[22]["bullets"][3]["spread_base"] = "claw"
			self.movementInput[22]["bullets"][3]["internal_cooldown"] = 28000
			self.movementInput[22]["bullets"][3]["delay"] = 4000-28000
			self.movementInput[22]["bullets"][3]["speed"] = 0
			self.movementInput[22]["bullets"][4] = {}
			self.movementInput[22]["bullets"][4]["type"] = 2
			self.movementInput[22]["bullets"][4]["i"] = 1
			self.movementInput[22]["bullets"][4]["spread_type"] = "shotgun"
			self.movementInput[22]["bullets"][4]["spread_angle"] = 20
			self.movementInput[22]["bullets"][4]["spread_base"] = "claw"
			self.movementInput[22]["bullets"][4]["spread_translation"] = 0
			self.movementInput[22]["bullets"][4]["internal_cooldown"] = 300
			self.movementInput[22]["bullets"][4]["shotgun_frags"] = 2
			self.movementInput[22]["bullets"][4]["delay"] = 5000
			self.movementInput[22]["bullets"][4]["speed"] = 2500
			self.movementInput[22]["bullets"][5] = {}
			self.movementInput[22]["bullets"][5]["type"] = 2 -- smarts
			self.movementInput[22]["bullets"][5]["i"] = 1
			self.movementInput[22]["bullets"][5]["spread_type"] = "circular"
			self.movementInput[22]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[22]["bullets"][5]["spread_angle"] = 30
			self.movementInput[22]["bullets"][5]["spread_translation"] = 0 -- arc difference from base direction
			self.movementInput[22]["bullets"][5]["internal_cooldown"] = 3000
			self.movementInput[22]["bullets"][5]["delay"] = 2000 -- delay from spell start
			self.movementInput[22]["bullets"][5]["speed"] = 3000
			self.movementInput[22]["bullets"][6] = {}
			self.movementInput[22]["bullets"][6]["type"] = 2 -- smarts
			self.movementInput[22]["bullets"][6]["i"] = 1
			self.movementInput[22]["bullets"][6]["spread_type"] = "circular"
			self.movementInput[22]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[22]["bullets"][6]["spread_angle"] = 30
			self.movementInput[22]["bullets"][6]["spread_translation"] = 10 -- arc difference from base direction
			self.movementInput[22]["bullets"][6]["internal_cooldown"] = 3000
			self.movementInput[22]["bullets"][6]["delay"] = 3000 -- delay from spell start
			self.movementInput[22]["bullets"][6]["speed"] = 3250
			self.movementInput[22]["bullets"][7] = {}
			self.movementInput[22]["bullets"][7]["type"] = 2 -- smarts
			self.movementInput[22]["bullets"][7]["i"] = 1
			self.movementInput[22]["bullets"][7]["spread_type"] = "circular"
			self.movementInput[22]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[22]["bullets"][7]["spread_angle"] = 30
			self.movementInput[22]["bullets"][7]["spread_translation"] = 20 -- arc difference from base direction
			self.movementInput[22]["bullets"][7]["internal_cooldown"] = 3000
			self.movementInput[22]["bullets"][7]["delay"] = 4000 -- delay from spell start
			self.movementInput[22]["bullets"][7]["speed"] = 3500
			
			self.movementInput[23] = {}
			self.movementInput[23]["spell_name"] = "Shrine Part 2"
			self.movementInput[23]["spell_card"] = "2"
			self.movementInput[23]["spell_length"] = 20000
			self.movementInput[23]["spell_totallength"] = 21500
			self.movementInput[23]["spell_type"] = "main"
			self.movementInput[23]["position"] = "MB"
			self.movementInput[23]["movement_pattern"] = "false"
			self.movementInput[23]["bullets"] = {}
			self.movementInput[23]["bullets"][1] = {}
			self.movementInput[23]["bullets"][1]["type"] = 5
			self.movementInput[23]["bullets"][1]["i"] = 1
			self.movementInput[23]["bullets"][1]["spread_type"] = "cleave"
			self.movementInput[23]["bullets"][1]["spread_origin"] = "top"
			self.movementInput[23]["bullets"][1]["spread_dstart"] = 30
			self.movementInput[23]["bullets"][1]["internal_cooldown"] = 1300
			self.movementInput[23]["bullets"][1]["delay"] = -1300
			self.movementInput[23]["bullets"][1]["speed"] = 1000
			self.movementInput[23]["bullets"][2] = {}
			self.movementInput[23]["bullets"][2]["type"] = 5
			self.movementInput[23]["bullets"][2]["i"] = 1
			self.movementInput[23]["bullets"][2]["spread_type"] = "cleave"
			self.movementInput[23]["bullets"][2]["spread_origin"] = "top"
			self.movementInput[23]["bullets"][2]["spread_dstart"] = 120
			self.movementInput[23]["bullets"][2]["internal_cooldown"] = 1300
			self.movementInput[23]["bullets"][2]["delay"] = -1300
			self.movementInput[23]["bullets"][2]["speed"] = 1000
			
			self.movementInput[24] = {}
			self.movementInput[24]["spell_name"] = "Shrine Part 3"
			self.movementInput[24]["spell_card"] = "2"
			self.movementInput[24]["spell_length"] = 16000
			self.movementInput[24]["spell_totallength"] = 18000
			self.movementInput[24]["spell_type"] = "main"
			self.movementInput[24]["position"] = "MB"
			self.movementInput[24]["movement_pattern"] = "false"
			self.movementInput[24]["bullets"] = {}
			self.movementInput[24]["bullets"][1] = {}
			self.movementInput[24]["bullets"][1]["type"] = 16
			self.movementInput[24]["bullets"][1]["i"] = 1
			self.movementInput[24]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[24]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[24]["bullets"][1]["spread_angle"] = 90
			self.movementInput[24]["bullets"][1]["spread_translation"] = 0
			self.movementInput[24]["bullets"][1]["internal_cooldown"] = 3900
			self.movementInput[24]["bullets"][1]["delay"] = -3900
			self.movementInput[24]["bullets"][1]["speed"] = 4000
			self.movementInput[24]["bullets"][2] = {}
			self.movementInput[24]["bullets"][2]["type"] = 16
			self.movementInput[24]["bullets"][2]["i"] = 1
			self.movementInput[24]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[24]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[24]["bullets"][2]["spread_angle"] = 90
			self.movementInput[24]["bullets"][2]["spread_translation"] = 30
			self.movementInput[24]["bullets"][2]["internal_cooldown"] = 3900
			self.movementInput[24]["bullets"][2]["delay"] = -2600
			self.movementInput[24]["bullets"][2]["speed"] = 4000
			self.movementInput[24]["bullets"][3] = {}
			self.movementInput[24]["bullets"][3]["type"] = 16
			self.movementInput[24]["bullets"][3]["i"] = 1
			self.movementInput[24]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[24]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[24]["bullets"][3]["spread_angle"] = 90
			self.movementInput[24]["bullets"][3]["spread_translation"] = 60
			self.movementInput[24]["bullets"][3]["internal_cooldown"] = 3900
			self.movementInput[24]["bullets"][3]["delay"] = -1300
			self.movementInput[24]["bullets"][3]["speed"] = 4000
			
			self.movementInput[25] = {}
			self.movementInput[25]["spell_name"] = "Shrine Part 4"
			self.movementInput[25]["spell_card"] = "2"
			self.movementInput[25]["spell_length"] = 25000
			self.movementInput[25]["spell_totallength"] = 32000
			self.movementInput[25]["spell_type"] = "main"
			self.movementInput[25]["position"] = "MB"
			self.movementInput[25]["movement_pattern"] = "false"
			self.movementInput[25]["bullets"] = {}
			self.movementInput[25]["bullets"][1] = {}
			self.movementInput[25]["bullets"][1]["type"] = 1
			self.movementInput[25]["bullets"][1]["i"] = 2
			self.movementInput[25]["bullets"][1]["spread_type"] = "circular"
			self.movementInput[25]["bullets"][1]["spread_angle"] = 20
			self.movementInput[25]["bullets"][1]["spread_base"] = "zero"
			self.movementInput[25]["bullets"][1]["spread_translation"] = 0
			self.movementInput[25]["bullets"][1]["internal_cooldown"] = 4600
			self.movementInput[25]["bullets"][1]["delay"] = -4600
			self.movementInput[25]["bullets"][1]["speed"] = 2900
			self.movementInput[25]["bullets"][2] = {}
			self.movementInput[25]["bullets"][2]["type"] = 1
			self.movementInput[25]["bullets"][2]["i"] = 2
			self.movementInput[25]["bullets"][2]["spread_type"] = "circular"
			self.movementInput[25]["bullets"][2]["spread_angle"] = 20
			self.movementInput[25]["bullets"][2]["spread_base"] = "zero"
			self.movementInput[25]["bullets"][2]["spread_translation"] = 15
			self.movementInput[25]["bullets"][2]["internal_cooldown"] = 4600
			self.movementInput[25]["bullets"][2]["delay"] = -3450
			self.movementInput[25]["bullets"][2]["speed"] = 2900
			self.movementInput[25]["bullets"][3] = {}
			self.movementInput[25]["bullets"][3]["type"] = 1
			self.movementInput[25]["bullets"][3]["i"] = 2
			self.movementInput[25]["bullets"][3]["spread_type"] = "circular"
			self.movementInput[25]["bullets"][3]["spread_angle"] = 20
			self.movementInput[25]["bullets"][3]["spread_base"] = "zero"
			self.movementInput[25]["bullets"][3]["spread_translation"] = 10
			self.movementInput[25]["bullets"][3]["internal_cooldown"] = 4600
			self.movementInput[25]["bullets"][3]["delay"] = -2300
			self.movementInput[25]["bullets"][3]["speed"] = 2900
			self.movementInput[25]["bullets"][4] = {}
			self.movementInput[25]["bullets"][4]["type"] = 1
			self.movementInput[25]["bullets"][4]["i"] = 2
			self.movementInput[25]["bullets"][4]["spread_type"] = "circular"
			self.movementInput[25]["bullets"][4]["spread_angle"] = 20
			self.movementInput[25]["bullets"][4]["spread_base"] = "zero"
			self.movementInput[25]["bullets"][4]["spread_translation"] = 5
			self.movementInput[25]["bullets"][4]["internal_cooldown"] = 4600
			self.movementInput[25]["bullets"][4]["delay"] = -1150
			self.movementInput[25]["bullets"][4]["speed"] = 2900
			self.movementInput[25]["bullets"][5] = {}
			self.movementInput[25]["bullets"][5]["type"] = 1
			self.movementInput[25]["bullets"][5]["i"] = 4
			self.movementInput[25]["bullets"][5]["spread_type"] = "shotgun"
			self.movementInput[25]["bullets"][5]["spread_angle"] = 12
			self.movementInput[25]["bullets"][5]["spread_base"] = "claw"
			self.movementInput[25]["bullets"][5]["spread_translation"] = 0
			self.movementInput[25]["bullets"][5]["internal_cooldown"] = 2300
			self.movementInput[25]["bullets"][5]["shotgun_frags"] = 3
			self.movementInput[25]["bullets"][5]["delay"] = -1725
			self.movementInput[25]["bullets"][5]["speed"] = 2900
			self.movementInput[25]["bullets"][6] = {}
			self.movementInput[25]["bullets"][6]["type"] = 1
			self.movementInput[25]["bullets"][6]["i"] = 4
			self.movementInput[25]["bullets"][6]["spread_type"] = "shotgun"
			self.movementInput[25]["bullets"][6]["spread_angle"] = 3
			self.movementInput[25]["bullets"][6]["spread_base"] = "claw"
			self.movementInput[25]["bullets"][6]["spread_translation"] = 0
			self.movementInput[25]["bullets"][6]["internal_cooldown"] = 2300
			self.movementInput[25]["bullets"][6]["shotgun_frags"] = 1
			self.movementInput[25]["bullets"][6]["skip_middle"] = 1
			self.movementInput[25]["bullets"][6]["delay"] = -575
			self.movementInput[25]["bullets"][6]["speed"] = 2900
			self.movementInput[25]["bullets"][7] = {}
			self.movementInput[25]["bullets"][7]["type"] = 4
			self.movementInput[25]["bullets"][7]["i"] = 3
			self.movementInput[25]["bullets"][7]["spread_type"] = "shotgun"
			self.movementInput[25]["bullets"][7]["spread_angle"] = 3
			self.movementInput[25]["bullets"][7]["spread_base"] = "claw"
			self.movementInput[25]["bullets"][7]["spread_translation"] = 0
			self.movementInput[25]["bullets"][7]["internal_cooldown"] = 2300
			self.movementInput[25]["bullets"][7]["shotgun_frags"] = 0
			self.movementInput[25]["bullets"][7]["delay"] = -575
			self.movementInput[25]["bullets"][7]["speed"] = 2900
			
			self.movementInput[26] = {}
			self.movementInput[26]["spell_name"] = "WIN!!!"
			self.movementInput[26]["spell_card"] = "2"
			self.movementInput[26]["spell_length"] = 1000
			self.movementInput[26]["spell_totallength"] = 1000
			self.movementInput[26]["spell_type"] = "repeating"
			self.movementInput[26]["position"] = "MB"
			self.movementInput[26]["movement_pattern"] = "false"
			self.movementInput[26]["spell_hp_threshold"] = 10
			self.movementInput[26]["bullets"] = {}
			self.movementInput[26]["bullets"][1] = {}
			self.movementInput[26]["bullets"][1]["type"] = 1
			self.movementInput[26]["bullets"][1]["i"] = 1
			self.movementInput[26]["bullets"][1]["spread_type"] = "victory"
			self.movementInput[26]["bullets"][1]["internal_cooldown"] = 1000
			self.movementInput[26]["bullets"][1]["delay"] = -900
			self.movementInput[26]["bullets"][1]["speed"] = 0
			self.movementInput[26]["bullets"][2] = {}
			self.movementInput[26]["bullets"][2]["type"] = 1
			self.movementInput[26]["bullets"][2]["i"] = 1
			self.movementInput[26]["bullets"][2]["spread_type"] = "domain_collapse"
			self.movementInput[26]["bullets"][2]["internal_cooldown"] = 1000
			self.movementInput[26]["bullets"][2]["delay"] = -900
			self.movementInput[26]["bullets"][2]["speed"] = 0
			
		end
		
		self.stage = 0
		self.count = 4
		self.shielded = 0
		self.shieldAngle = 0
		
		self.spellcycle = 0
		self.movement = false
		self.spellcycleflag = 1
		self.spellused = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
		self.bulletlastused = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
		self.bulletinterval = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
		
		
		self.Moving = 0
		self.MovXStart = 0
		self.MovYStart = 0
		self.MovXFin = 0
		self.MovYFin = 0
		self.MovTStart = 0
		self.MovAngle = 0
		self.State = 1
	elseif self.State == 1 then -- 1 - between attacks
		local claw = GetClaw()
		
		--if self.stage == 11 then
		--	self.State = 10
		--end
		--local aa = ""
		--for ii,v in ipairs(self.bulletlastused) do
		--	aa = aa .. " " .. v-GetTime()
		--end
		--TextOut(aa)
		if (claw.State == 5009 and self.stage ~= 8) or claw.Health <= 0 then
			self.stage = 0
		end
		LookAtClaw(self)
		if self.stage == 0 and self.Activate ~= nil then
			self.stage = 1 -- start at 1st stage
			if self.MPcheckpointFlag ~= nil then
				self.stage = 7
			end
		end
		
		--end
	elseif self.State == 2 then -- 2 - getting hit
		if self.TempStunCounter <= GetTime() then
			self.State = 1
			--self:SetAnimation("LEVEL_REDTAIL_IDLE")
			self.TimeCounter = GetTime() + 1000
		end
	end
	self:SetFrame(self.I)
	
	if self.State ~= 10 then
		if self.shielded == 1 then
			local heX = self.hotX
			local heY = self.hotY
			if self.phantomAreti ~= nil then
				if self.phantomAreti.hotX ~= nil and self.phantomAreti.hotY ~= nil then
					heX = self.phantomAreti.hotX
					heY = self.phantomAreti.hotY
				end
			end
			if self.OmarShield == nil then
				self.OmarShield = {}
				for i=1, 12, 1 do
					self.OmarShield[i] = CreateObject {x=heX+math.cos(math.rad(i*30)+self.shieldAngle)*74, y=heY+math.sin(math.rad(i*30)+self.shieldAngle)*74, z=6000, I=i%6, logic="AniCycle", image="CUSTOM_ICESHIELD"}
					self.OmarShield[i].Flags.AlwaysActive = true
				end
				self.shieldAngle = self.shieldAngle + 0.06
			else
				for i=1, 12, 1 do
					self.OmarShield[i].X = heX+math.cos(math.rad(i*30)+self.shieldAngle)*74
					self.OmarShield[i].Y = heY+math.sin(math.rad(i*30)+self.shieldAngle)*74
					self.OmarShield[i].DrawFlags.NoDraw = false
				end
				self.shieldAngle = self.shieldAngle + 0.06
				if self.shieldAngle > 360 then
					self.shieldAngle = self.shieldAngle - 360
				end
			end
			
		elseif self.shielded == 0 then
			if self.OmarShield ~= nil then
				for i=1, 12, 1 do
					self.OmarShield[i].DrawFlags.NoDraw = true
				end
			end
		end
	else
		if self.endFlag == nil and self.OmarShield ~= nil then
			self.endFlag = 1
			for i=1, 12, 1 do
				self.OmarShield[i]:Destroy()
				self.OmarShield[i]:Destroy()
			end
		end
	end
	
	--if self.Activate ~= nil then
		--TextOut(self.State .. " " .. self.stage .. " " .. self.Activate)
	--end
	self.X = self.hotX
	self.Y = self.hotY + getFloatingYModifier()
	if self.stage ~= nil then
		if self.stage >= 1 then
			if self.anticheat ~= nil then
				if self.anticheat >= GetTime() + 400 and (self.Achievements.HardMode == true or self.Achievements.extra == true) then
					TextOut("DO NOT CHEAT")
					KillClaw()
				end
			end
			self.anticheat = GetTime()
			-- if outside of target zone, move there
			itzone = IsInTheZone(self, self.movementInput[self.stage]["position"])
			if itzone ~= -99 then
				self.hotX = self.hotX + math.cos(itzone)*4
				self.hotY = self.hotY + math.sin(itzone)*4
				self.I = 3
			-- move to next stage from timed spells
			elseif self.movementInput[self.stage]["spell_type"] == "main" and GetClaw().Health > 0 then
				if GetTime() > self.spellcycle + self.movementInput[self.stage]["spell_totallength"] then
					self.spellcycleflag = 1
					self.stage = self.stage + 1
					self.spellcycle = GetTime() --!!
					if self.DrawFlags.NoDraw == true then
						self.DrawFlags.NoDraw = false
						self.hotX = self.phantomAreti.hotX
						self.hotY = self.phantomAreti.hotY
						self.phantomAreti:Destroy()
						self.phantomAreti = nil
					end
				elseif self.movementInput[self.stage]["movement_pattern"] ~= "false" then
					if self.movementInput[self.stage]["movement_pattern"] == "phantom" then
						if self.phantomAreti == nil then
							self.DrawFlags.NoDraw = true
							self.phantomAreti = CreateObject {x=self.hotX, y=self.hotY, z=4000, I=1, name="PhantomAreti", logic="CustomLogic", image="CUSTOM_ARETI"}
							self.phantomAreti.Flags.AlwaysActive = true
						end
					end
				end
			-- move to next stage from intermediate stages
			elseif self.movementInput[self.stage]["spell_type"] == "repeating" and GetClaw().Health > 0 then
				if GetTime() > self.spellcycle + self.movementInput[self.stage]["spell_totallength"] then
					self.spellcycleflag = 1
					if self.movementInput[self.stage]["movement_pattern"] ~= "false" then
						if self.movementInput[self.stage]["movement_pattern"] == "clockwise" then
							if self.movementInput[self.stage]["position"] == "LT" then
								self.movementInput[self.stage]["position"] = "MT"
							elseif self.movementInput[self.stage]["position"] == "MT" then
								self.movementInput[self.stage]["position"] = "RT"
							elseif self.movementInput[self.stage]["position"] == "RT" then
								self.movementInput[self.stage]["position"] = "RB"
							elseif self.movementInput[self.stage]["position"] == "RB" then
								self.movementInput[self.stage]["position"] = "MB"
							elseif self.movementInput[self.stage]["position"] == "MB" then
								self.movementInput[self.stage]["position"] = "LB"
							elseif self.movementInput[self.stage]["position"] == "LB" then
								self.movementInput[self.stage]["position"] = "LT"
							end
						end
					end
				end
				if self.Health <= self.movementInput[self.stage]["spell_hp_threshold"] then
					self.stage = self.stage + 1
					self.spellcycle = GetTime() --!!
					self.spellcycleflag = 1
				end
			end
			itzone = IsInTheZone(self, self.movementInput[self.stage]["position"])
			-- zero-out cooldowns
			if self.spellcycleflag == 1 and itzone == -99 then
				self.spellcycleflag = 0
				self.movementflag = 0
				self.spellcycle = GetTime()
				--for i,v in ipairs(self.spellused) do
				--	self.spellused[1] = 0
				--end
				
				for i,v in ipairs(self.movementInput[self.stage]["bullets"]) do
					self.bulletlastused[i] = GetTime() + v["delay"]
				end
				for i,v in ipairs(self.movementInput[self.stage]["bullets"]) do
					self.bulletinterval[i] = v["spread_dstart"]
				end
			end
			-- invulnerability during timed spells
			if self.movementInput[self.stage]["spell_type"] == "main" then
				self.shielded = 1
			elseif self.movementInput[self.stage]["spell_type"] == "repeating" then
				self.shielded = 0
			end
			
			-- bullet types logic here
			if GetTime() <= self.spellcycle + self.movementInput[self.stage]["spell_length"] and self.spellcycleflag == 0 then
				if self.State ~= 10 then
					if self.stage <= 21 then
						self.I = 4
					else--if self.stage <= 25 then
						if self.DEtimer == nil or self.I <= 4 then
							self.I = 5
							self.DEtimer = GetTime() + 1800
						elseif GetTime() >= self.DEtimer and self.I == 5 then
							self.I = 6
							self.DEtimer = GetTime() + 200
						elseif GetTime() >= self.DEtimer and self.I == 6 then
							self.I = 7
							self.DEtimer = GetTime() + 200
						elseif GetTime() >= self.DEtimer and self.I == 7 then
							self.I = 8
							self.DEtimer = GetTime() + 200
						end
					end
				end
				-- iterate through every bullet
				for i,v in ipairs(self.movementInput[self.stage]["bullets"]) do
					
					if GetTime() >= self.bulletlastused[i] + v["internal_cooldown"] and GetClaw().Health > 0 then
						if self.TimeStoppedTill > GetTime() and v["type"] ~= 6 then
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						-- circular bullet type
						elseif v["spread_type"] == "circular" then
							local baseangle = 0
							if v["spread_base"] == "claw" then
								baseangle = GetAngleFacingClaw(self)
							elseif v["spread_base"] == "zero" then
								baseangle = 0
							end
							for j=baseangle+v["spread_translation"],baseangle+(360-v["spread_angle"])+v["spread_translation"],v["spread_angle"] do
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						
						-- shotgun bullet type
						elseif v["spread_type"] == "shotgun" then
							local baseangle = 0
							if v["spread_base"] == "claw" then
								baseangle = GetAngleFacingClaw(self)
							elseif v["spread_base"] == "zero" then
								baseangle = 0
							end
							local tsvar = 0
							if v["tsdistance"] ~= nil then
								tsvar = v["tsdistance"]
							end
							if v["skip_middle"] == nil then
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = baseangle+v["spread_translation"], Smarts = v["type"], Health = v["speed"], Points = tsvar}
								b.Flags.AlwaysActive = true
							end
							if v["shotgun_frags"] >= 1 then
								for j=1.0,v["shotgun_frags"],1.0 do
									local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = baseangle+v["spread_translation"]-(v["spread_angle"]*j), Smarts = v["type"], Health = v["speed"], Points = tsvar}
									b.Flags.AlwaysActive = true
									local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = baseangle+v["spread_translation"]+(v["spread_angle"]*j), Smarts = v["type"], Health = v["speed"], Points = tsvar}
									b.Flags.AlwaysActive = true
								end
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						
						-- rain bullet type
						elseif v["spread_type"] == "rain" then
							local BstartY = 0
							local angle = 90
							if v["spread_origin"] == "top" then
								angle = 90
								BstartY = 1100
							elseif v["spread_origin"] == "bottom" then
								angle = -90
								BstartY = 2370
							elseif v["spread_origin"] == "right" then
								angle = 0
								BstartX = 11396
							elseif v["spread_origin"] == "left" then
								angle = 180
								BstartX = 12358
							end
							if v["spread_origin"] == "top" or v["spread_origin"] == "bottom" then
								local BoundaryLeft = 11394
								local BoundaryRight = 12360
								if v["behaviour"] == 2 then
									bv2 = BoundaryLeft/2+BoundaryRight/2+(200*math.sin((GetTime()-self.spellcycle)/1400))
								end
								for xx=BoundaryLeft,BoundaryRight,v["spread_distance"] do
									if xx + self.bulletinterval[i] <= BoundaryRight then
										local bI = v["i"]
										if v["behaviour"] == 1 then
											angle = GetAngleFacingClaw2(xx + self.bulletinterval[i],BstartY)
										end
										if v["behaviour"] == 2 then
											if xx + self.bulletinterval[i] < bv2 then
												bI = 1
											else
												bI = 2
											end
										end
										if v["behaviour"] ~= 2 or math.abs(xx+self.bulletinterval[i]-bv2) > math.max(24,80-(80 * (GetTime()-self.spellcycle)/(self.movementInput[self.stage]["spell_totallength"]))) then
											local b = CreateObject {x=xx + self.bulletinterval[i], y=BstartY, z=4100, I=bI, name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
											b.Flags.AlwaysActive = true
										end
									end
								end
								self.bulletinterval[i] = self.bulletinterval[i] + v["spread_interval"]
								if self.bulletinterval[i] >= v["spread_distance"] then
									self.bulletinterval[i] = self.bulletinterval[i] - v["spread_distance"]
								end
							elseif v["spread_origin"] == "left" or v["spread_origin"] == "right" then
								local BoundaryBottom = 2374
								local BoundaryTop = 1094
								for xx=BoundaryTop,BoundaryBottom,v["spread_distance"] do
									if xx + self.bulletinterval[i] <= BoundaryBottom then
										if v["behaviour"] == 1 then
											angle = GetAngleFacingClaw2(BstartX,xx + self.bulletinterval[i])
										end
										local b = CreateObject {x=BstartX, y=xx + self.bulletinterval[i], z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
										b.Flags.AlwaysActive = true
									end
								end
								self.bulletinterval[i] = self.bulletinterval[i] + v["spread_interval"]
								if self.bulletinterval[i] >= v["spread_distance"] then
									self.bulletinterval[i] = self.bulletinterval[i] - v["spread_distance"]
								end
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						
						-- clockwise bullet type
						elseif v["spread_type"] == "clockwise" then
							angle = self.bulletinterval[i]
							claw = GetClaw()
							if angle == 90 then
								BstartY = 1100
								local b = CreateObject {x=claw.X, y=BstartY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							elseif angle == 270 then
								BstartY = 2370
								local b = CreateObject {x=claw.X, y=BstartY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							elseif angle == 180 then
								BstartX = 12358
								local b = CreateObject {x=BstartX, y=claw.Y, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							elseif angle == 0 then
								BstartX = 11396
								local b = CreateObject {x=BstartX, y=claw.Y, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletinterval[i] = self.bulletinterval[i] + 90
							if self.bulletinterval[i] >= 360 then
								self.bulletinterval[i] = self.bulletinterval[i] - 360
							end
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						elseif v["spread_type"] == "cleave" then
							angle = self.bulletinterval[i]
							claw = GetClaw()
							
							local b = CreateObject {x=claw.X, y=claw.Y, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"]}
							b.Flags.AlwaysActive = true
							b = CreateObject {x=claw.X, y=claw.Y, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle+180, Smarts = v["type"], Health = v["speed"]}
							b.Flags.AlwaysActive = true
							
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletinterval[i] = self.bulletinterval[i] + 30
							if self.bulletinterval[i] >= 360 then
								self.bulletinterval[i] = self.bulletinterval[i] - 360
							end
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
							
						-- timestop bullet type
						elseif v["spread_type"] == "timestop" then
							self.TimeStoppedTill = GetTime() + v["length"]
							self.TimeStoppedDuration = v["length"]
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						-- orbiting bullet type
						elseif v["spread_type"] == "orbit" then
							local baseangle = 0
							baseangle = 0
							for j=baseangle,baseangle+(360-v["spread_angle"]),v["spread_angle"] do
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j, Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						elseif v["spread_type"] == "fall" then
							local BoundaryLeft = 11392
							local BoundaryRight = 12362
							local BoundaryBottom = 2374
							local BoundaryTop = 1094
							local startx = 0
							local starty = 0
							for repeats=1,v["repeats"] do
								if v["spread_base"] == "random" then
									startx = RandBetween(BoundaryLeft + 1, BoundaryRight - 1)
									starty = RandBetween(BoundaryTop + 1, BoundaryBottom - 1)
									local angle = GetAngleFacingSelf(self, startx, starty)
									local b = CreateObject {x=startx, y=starty, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
								elseif v["spread_base"] == "boundaries" then
									local x1 = RandBetween(BoundaryLeft + 1, BoundaryRight - 1)
									local x2 = RandBetween(BoundaryLeft + 1, BoundaryRight - 1)
									local y1 = RandBetween(BoundaryTop + 1, BoundaryBottom - 1)
									local y2 = RandBetween(BoundaryTop + 1, BoundaryBottom - 1)
									local y3 = RandBetween(BoundaryTop + 1, BoundaryBottom - 1)
									-- top
									local angle = GetAngleFacingSelf(self, x1, BoundaryTop + 1)
									local b = CreateObject {x=x1, y=BoundaryTop + 1, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
									angle = GetAngleFacingSelf(self, x2, BoundaryBottom - 1)
									b = CreateObject {x=x2, y=BoundaryBottom - 1, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
									
									angle = GetAngleFacingSelf(self, BoundaryLeft + 1, y1)
									b = CreateObject {x=BoundaryLeft
									 + 1, y=y1, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
									angle = GetAngleFacingSelf(self, BoundaryRight - 1, y2)
									b = CreateObject {x=BoundaryRight - 1, y=y2, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
									
									--angle = GetAngleFacingSelf(self, BoundaryRight - 1, y3)
									--b = CreateObject {x=BoundaryRight - 1, y=y3, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									--b.Flags.AlwaysActive = true
								elseif v["spread_base"] == "proximity" then
									local claw = GetClaw()
									local right = 0
									local left = 0
									if claw.X > self.X then
										right = 100
									else
										left = 100
									end
									local st_x = claw.X + RandBetween(-192+right,192-left)
									local st_y = claw.Y + RandBetween(-192,192)
									local angle = GetAngleFacingSelf(self, st_x, st_y)
									local b = CreateObject {x=st_x, y=st_y, z=7014, I=v["i"], name="DelayedBullet", logic="CustomLogic", image="CUSTOM_ELDRITCHWARP", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
								elseif v["spread_base"] == "claw" then
									local claw = GetClaw()
									local angle = GetAngleFacingSelf(self, claw.X, claw.Y)
									if rand() < 0.33 then
										angle = 0
									end
									local b = CreateObject {x=claw.X, y=claw.Y, z=7014, I=v["i"], name="DelayedBullet", logic="CustomLogic", image="CUSTOM_ELDRITCHWARP", Damage = 0, Counter = angle, Smarts = v["type"], Health = v["speed"], SpeedX = self.hotX, SpeedY = self.hotY}
									b.Flags.AlwaysActive = true
								end
							end
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						elseif v["spread_type"] == "pulsar" then
							for j=v["spread_translation"],(360-v["spread_angle"])+v["spread_translation"],v["spread_angle"] do
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = j + self.bulletinterval[i], Smarts = v["type"], Health = v["speed"]}
								b.Flags.AlwaysActive = true
							end
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							
							self.bulletinterval[i] = self.bulletinterval[i] + v["spread_interval"]
							if self.bulletinterval[i] >= 360 then
								self.bulletinterval[i] = self.bulletinterval[i] - 360
							end
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						elseif v["spread_type"] == "hunterseeker" then
							if v["behaviour"] == 0 then
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="HunterSeeker", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.bulletinterval[i], Smarts = v["type"], Speed = v["duration"]}
								b.Flags.AlwaysActive = true
							elseif v["behaviour"] == 1 then
								local b = CreateObject {x=self.hotX, y=self.hotY, z=4100, I=v["i"], name="HunterSeeker2", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = self.bulletinterval[i], Smarts = v["type"], Speed = v["duration"]}
								b.Flags.AlwaysActive = true
							end
							
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						elseif v["spread_type"] == "sinewave" then
							local startingX = self.X
							local startingY = self.Y
							if self.phantomAreti ~= nil then
								startingX = self.phantomAreti.X
								startingY = self.phantomAreti.Y
							end
							startingY = startingY + math.sin(GetTime()/400)*(48)-10
							
							local b = CreateObject {x=startingX, y=startingY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = 0, Smarts = v["type"], Health = v["speed"]}
							b.Flags.AlwaysActive = true
							b = CreateObject {x=startingX, y=startingY, z=4100, I=v["i"], name="Danmaku", logic="CustomLogic", image="CUSTOM_DANMAKU", Damage = 0, Counter = 180, Smarts = v["type"], Health = v["speed"]}
							b.Flags.AlwaysActive = true
							
							--PlaySound("CUSTOM_TRIGGER_ENEP2")
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						
						elseif v["spread_type"] == "phantom_movement" then
							if self.phantomAreti ~= nil then
								if self.phantomAreti.hotX ~= nil then
									if v["movement_type"] == "vertical_ascend" then
										local time_start = self.bulletlastused[i] + 5000
										local time_end = time_start + self.movementInput[self.stage]["spell_length"]
										local per_cent = (GetTime()-time_start)/(time_end-time_start)
										local phantom_diff = v["endY"] - self.phantomAreti.origY
										self.phantomAreti.hotY = math.ceil(self.phantomAreti.origY + phantom_diff * per_cent)
									end
								end
							end
						elseif v["spread_type"] == "camera" then
							if v["spread_base"] == "areti" then
								CameraToObject(self)
							elseif v["spread_base"] == "claw" then
								CameraToClaw()
							end
							--TextOut(self.State)
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
							
						elseif v["spread_type"] == "domain_expansion" then
							if version > 1444 then
								GetFirstPalette():Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
								GetCurrentPalette():AdjustRGB(-10,-10,5):Set()
								GetCurrentPalette():AdjustHSL(-5,0,0):Set()
							end
							--TextOut(self.State)
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
							
						elseif v["spread_type"] == "domain_collapse" then
							if version > 1444 then
								GetFirstPalette():Set()
							end
							--TextOut(self.State)
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
							
						elseif v["spread_type"] == "victory" then
							self.I = 4
							self.State = 10
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
							
						elseif v["spread_type"] == "mpcheckpoint" then
							if self.mpcheckpointflag2 == nil then
								if GetGameType() == 4 then
									if self.MPcheckpointFlag == nil then
										self.MPcheckpointFlag = true
										TextOut("Multiplayer checkpoint reached")
									end
								end
								self.mpcheckpointflag2 = true
							end
							
							self.bulletlastused[i] = self.bulletlastused[i] + v["internal_cooldown"]
						end
					end
				end
			end
		end
	end
end

function hit(self)
	
	--local claw = GetClaw()
	--if self.State == 1 then
		
		--TextOut(self.HitRef.ObjectTypeFlags)
		if self.HitRef.ObjectTypeFlags == 2 and self.State == 1 then
			
			if self.shielded == 0 then
				self.State = 2
				CreateObject {x=self.X, y=self.HitRef.Y, z=9000, name="EnemyHit", logic="CustomLogic", image="GAME_ENEMYHIT"}
				local r = rand()
				if r<0.25 then
					PlaySound("GAME_HIT1")
				elseif r<0.5 then
					PlaySound("GAME_HIT2")
				elseif r<0.75 then
					PlaySound("GAME_HIT3")
				else
					PlaySound("GAME_HIT4")
				end
				if GetClaw().State == 26 then
					self.Health = self.Health - 5
				else
					self.Health = self.Health - 5
				end
				self.TempStunCounter = GetTime() + 500 -- póki nie ma animacji, 1/2 sekundy nieśmiertelności po otrzymaniu obrażeń
			else
				if self.phantomAreti == nil then
					PlaySound("CUSTOM_TRIGGER_BLOCK2")
				end
				self.State = 2
				self.TempStunCounter = GetTime() + 500
			end
		elseif self.HitRef.ObjectTypeFlags == 32 or self.HitRef.Logic==Dynamite then
			self.HitRef.Y = 9900
			--PlaySound("LEVEL_REDTAIL_BLOCK2")
			--self.QuickReloadCounter = 2
			if self.TimeCounter-GetTime() < self.NormalReload then
				self.TimeCounter = self.TimeCounter + 500
			else
				self.TimeCounter = GetTime() + self.NormalReload + 500
			end
		elseif self.HitRef.Logic==MagicBullet then
			self.HitRef.Y = 9900
			--PlaySound("LEVEL_REDTAIL_BLOCK2")
			--self.QuickReloadCounter = 2
			self.TimeCounter = GetTime() + self.NormalReload + 500
		end
		--TextOut(GetClaw().State)
		
		
	--end
end 
